/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.injection;

import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.servlet.RequestScoped;
import org.appops.core.constant.CoreGuiceConstant;
import org.appops.core.deployment.DeploymentConfig;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.service.CurrentDeploymentProvider;
import org.appops.service.client.Client;
import org.appops.service.client.ClientProvider;
import org.appops.service.client.handler.ClientHandler;
import org.appops.service.client.handler.ClientHandlerProvider;
import org.appops.service.invocation.OperationDecorator;
import org.appops.service.job.JobExecService;
import org.appops.service.job.JobExecServiceImpl;
import org.appops.service.request.ServiceApiFilter;
import org.appops.service.store.RequestParameterStore;
import org.appops.service.store.RequestParameterStoreImpl;

/**
 * <p>
 * ServiceBaseModule class.
 * </p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class ServiceBaseModule extends BaseServletModule {


  /** {@inheritDoc} */
  @Override
  public void configureModule() {
    final OperationDecorator decorator = new OperationDecorator();
    requestInjection(decorator);
    bindInterceptor(Matchers.any(), Matchers.annotatedWith(ServiceOp.class), decorator);
    bind(DeploymentConfig.class).annotatedWith(Names.named(CoreGuiceConstant.CURRENT_DEPLOYMENT))
        .toProvider(CurrentDeploymentProvider.class).in(Singleton.class);
    bind(JobExecService.class).to(JobExecServiceImpl.class);

    bind(ServiceApiFilter.class).in(Singleton.class);
    filter("/*").through(ServiceApiFilter.class);

    bind(Client.class).toProvider(ClientProvider.class).in(RequestScoped.class);
    bind(ClientHandler.class).toProvider(ClientHandlerProvider.class).in(RequestScoped.class);
    bind(RequestParameterStore.class).to(RequestParameterStoreImpl.class).in(RequestScoped.class);
  }

}
