/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Maps;
import com.google.inject.OutOfScopeException;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

class ContinuingHttpServletRequest
extends HttpServletRequestWrapper {
    private final Map<String, Object> attributes = Maps.newHashMap();
    private final Cookie[] cookies;

    public ContinuingHttpServletRequest(HttpServletRequest request) {
        super(request);
        Cookie[] originalCookies = request.getCookies();
        if (originalCookies != null) {
            int numberOfCookies = originalCookies.length;
            this.cookies = new Cookie[numberOfCookies];
            for (int i = 0; i < numberOfCookies; ++i) {
                Cookie originalCookie = originalCookies[i];
                this.cookies[i] = originalCookie instanceof ImmutableCookie ? originalCookie : new ImmutableCookie(originalCookie);
            }
        } else {
            this.cookies = null;
        }
    }

    @Override
    public HttpSession getSession() {
        throw new OutOfScopeException("Cannot access the session in a continued request");
    }

    @Override
    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("Cannot access the session in a continued request");
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Cannot access raw request on a continued request");
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Cookie[] getCookies() {
        return this.cookies;
    }

    private static final class ImmutableCookie
    extends Cookie {
        public ImmutableCookie(Cookie original) {
            super(original.getName(), original.getValue());
            super.setMaxAge(original.getMaxAge());
            super.setPath(original.getPath());
            super.setComment(original.getComment());
            super.setSecure(original.getSecure());
            super.setValue(original.getValue());
            super.setVersion(original.getVersion());
            if (original.getDomain() != null) {
                super.setDomain(original.getDomain());
            }
        }

        @Override
        public void setComment(String purpose) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        @Override
        public void setDomain(String pattern) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        @Override
        public void setMaxAge(int expiry) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        @Override
        public void setPath(String uri) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        @Override
        public void setSecure(boolean flag) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        @Override
        public void setValue(String newValue) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        @Override
        public void setVersion(int v) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }
    }
}

