/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.util.date;

import com.strategicgains.util.AdapterCallback;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Iso8601TimepointCallback
implements AdapterCallback<String> {
    private static final String SHORT_TZ_REGEX = ".*T.*[-+]\\d\\d$";
    private static final String COLON_DELIM_TZ_REGEX = "([-+]\\d\\d):(\\d\\d)$";
    private static final Pattern SHORT_TZ_PATTERN = Pattern.compile(".*T.*[-+]\\d\\d$");
    private static final Pattern COLON_TZ_PATTERN = Pattern.compile(".*T.*([-+]\\d\\d):(\\d\\d)$");

    @Override
    public String process(String string) {
        Matcher colonMatcher = COLON_TZ_PATTERN.matcher(string);
        if (colonMatcher.matches()) {
            return string.replaceAll(COLON_DELIM_TZ_REGEX, colonMatcher.group(1) + colonMatcher.group(2));
        }
        if (SHORT_TZ_PATTERN.matcher(string).matches()) {
            return string + "00";
        }
        return string;
    }
}

