/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.core.service.ExecutionMode;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.service.exception.DeploymentException;
import org.appops.service.generator.ServiceMetaGenerator;
import org.appops.slim.base.api.ServiceMetaManager;

public abstract class ServiceInitializer {
    private Provider<ServiceMetaGenerator> serviceMetaGenerator;
    private Provider<ServiceMetaManager> serviceMetaManager;

    @Inject
    public ServiceInitializer(Provider<ServiceMetaGenerator> serviceMetaGenerator, Provider<ServiceMetaManager> serviceMetaManager) {
        this.serviceMetaGenerator = serviceMetaGenerator;
        this.serviceMetaManager = serviceMetaManager;
    }

    public abstract String initialize(String var1, ServiceConfiguration var2, Class<? extends Annotation> var3);

    protected String addServiceMeta(String serviceName, ServiceConfiguration config, Class<? extends Annotation> serviceAnnotation) {
        try {
            ServiceMeta serviceMeta = config.getExecutionMode().equals((Object)ExecutionMode.JOB) ? this.serviceMetaGenerator.get().generateJesMeta(serviceName, config.getWebConfig().getContextPath(), config.serviceUrl(), "", serviceAnnotation) : this.serviceMetaGenerator.get().generateServiceMeta(serviceName, config.getWebConfig().getContextPath(), config.serviceUrl(), serviceAnnotation);
            this.serviceMetaManager.get().registerServiceMeta(serviceMeta);
            return serviceMeta.getName();
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to add service meta :: " + e);
        }
    }
}

