/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.client;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.appops.service.client.ApiClient;
import org.appops.service.client.BaseClient;
import org.appops.service.client.Client;
import org.appops.service.client.WebClient;

public class ClientProvider
implements Provider<Client> {
    @Inject
    HttpServletRequest httpServletRequest;
    @Inject
    Injector injector;

    @Override
    public Client get() {
        return this.getClient();
    }

    public Client getClient() {
        return this.instantiateClient();
    }

    private Client instantiateClient() {
        BaseClient client;
        String browserDetails;
        String userAgent = browserDetails = this.httpServletRequest.getHeader("User-Agent");
        String user = userAgent.toLowerCase();
        String os = "";
        String browser = "";
        os = userAgent.toLowerCase().indexOf("windows") >= 0 ? "Windows" : (userAgent.toLowerCase().indexOf("mac") >= 0 ? "Mac" : (userAgent.toLowerCase().indexOf("x11") >= 0 ? "Linux" : (userAgent.toLowerCase().indexOf("android") >= 0 ? "Android" : (userAgent.toLowerCase().indexOf("iphone") >= 0 ? "IPhone" : "UnKnown"))));
        if (user.contains("msie")) {
            String substring = userAgent.substring(userAgent.indexOf("MSIE")).split(";")[0];
            browser = substring.split(" ")[0].replace("MSIE", "IE") + "-" + substring.split(" ")[1];
        } else if (user.contains("safari") && user.contains("version")) {
            browser = userAgent.substring(userAgent.indexOf("Safari")).split(" ")[0].split("/")[0] + "-" + userAgent.substring(userAgent.indexOf("Version")).split(" ")[0].split("/")[1];
        } else if (user.contains("opr") || user.contains("opera")) {
            if (user.contains("opera")) {
                browser = userAgent.substring(userAgent.indexOf("Opera")).split(" ")[0].split("/")[0] + "-" + userAgent.substring(userAgent.indexOf("Version")).split(" ")[0].split("/")[1];
            } else if (user.contains("opr")) {
                browser = userAgent.substring(userAgent.indexOf("OPR")).split(" ")[0].replace("/", "-").replace("OPR", "Opera");
            }
        } else {
            browser = user.contains("chrome") ? userAgent.substring(userAgent.indexOf("Chrome")).split(" ")[0].replace("/", "-") : (user.indexOf("mozilla/7.0") > -1 || user.indexOf("netscape6") != -1 || user.indexOf("mozilla/4.7") != -1 || user.indexOf("mozilla/4.78") != -1 || user.indexOf("mozilla/4.08") != -1 || user.indexOf("mozilla/3") != -1 ? "Netscape-?" : (user.contains("firefox") ? userAgent.substring(userAgent.indexOf("Firefox")).split(" ")[0].replace("/", "-") : (user.contains("rv") ? "IE-" + user.substring(user.indexOf("rv") + 3, user.indexOf(")")) : "UnKnown")));
        }
        if ((os.equals("Android") || os.equals("IPhone") || os.equals("UnKnown")) && browser.equals("UnKnown")) {
            client = this.injector.getInstance(ApiClient.class);
            client.setOs(os);
            return client;
        }
        client = this.injector.getInstance(WebClient.class);
        client.setOs(os);
        ((WebClient)client).setBrowserName(browser);
        return client;
    }
}

