/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.deployment;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.util.Collection;
import org.appops.core.ClassPathAnalyser;
import org.appops.core.util.ZipUtils;
import org.appops.service.deployment.DeploymentPackager;

public class DeploymentBackupFacilitator {
    @Inject
    private Injector injector;

    public void backupDeployment(File outputDir, boolean createZip) {
        ClassPathAnalyser cpa = new ClassPathAnalyser();
        Collection<Class<DeploymentPackager>> servicePackagers = cpa.subTypesOf(DeploymentPackager.class);
        outputDir.mkdirs();
        for (Class<DeploymentPackager> servicePackager : servicePackagers) {
            try {
                this.injector.getInstance(servicePackager).packageDep(outputDir);
            }
            catch (Exception e) {
                String canonicalName = servicePackager.getCanonicalName();
                System.err.println("Failed to backup dep from -> " + canonicalName + "::" + e);
            }
        }
        new ZipUtils().zip(outputDir, new File(outputDir.getPath() + ".zip"));
    }
}

