/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.entrypoint;

import java.io.File;
import java.util.HashMap;
import org.appops.core.ServiceException;

public class ServiceArgs {
    private String profileUsed = "default";
    private String profileRoot = "env-config/";
    private static String CORE_CONFIG = "coreConfig";
    private String deploymentMode = "CLUBBED";
    private HashMap<String, String> argMap = new HashMap();

    public ServiceArgs(String[] args) throws ServiceException {
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                throw new ServiceException("Invalid arguments while starting service. Service arguments can be provided with format --[argName]=[argValue] \" e.g. java MyServiceEntryPoint --profile.root=\"./\" ) --service.mode=CLUBBED --service.root=./");
            }
            String[] keyValue = arg.split("=", 0);
            keyValue[0] = keyValue[0].substring(2);
            if (keyValue.length == 2) {
                this.argMap.put(keyValue[0], keyValue[1]);
                continue;
            }
            System.out.println("Skipped argument without value --> " + keyValue[0]);
        }
        if (this.argMap.get("profile.name") != null) {
            this.profileUsed = this.argMap.get("profile.name");
        }
        if (this.argMap.get("profile.root") != null) {
            this.profileRoot = this.argMap.get("profile.root");
        }
        if (this.argMap.get("deployment.mode") != null) {
            this.deploymentMode = this.argMap.get("deployment.mode");
        }
        this.addDefaults();
    }

    private ServiceArgs withServiceConfig(String serviceConfigPath) {
        if (this.checkNullOrEmpty(serviceConfigPath)) {
            this.argMap.put(CORE_CONFIG, serviceConfigPath);
        }
        return this;
    }

    public File getServiceConfig() {
        return new File(this.argMap.get(CORE_CONFIG));
    }

    private void addDefaults() {
        this.withServiceConfig(this.profileRoot + this.profileUsed + "/core.yml");
    }

    private boolean checkNullOrEmpty(Object value) {
        return value != null && (!(value instanceof String) || !((String)value).isEmpty());
    }

    public String getSelectedProfileName() {
        return this.profileUsed;
    }

    public String getProfileRoot() {
        return this.profileRoot;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public HashMap<String, String> getServiceArgs() {
        return this.argMap;
    }
}

