/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.injection;

import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.servlet.RequestScoped;
import org.appops.core.deployment.DeploymentConfig;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.service.CurrentDeploymentProvider;
import org.appops.service.client.Client;
import org.appops.service.client.ClientProvider;
import org.appops.service.client.handler.ClientHandler;
import org.appops.service.client.handler.ClientHandlerProvider;
import org.appops.service.injection.BaseServletModule;
import org.appops.service.invocation.OperationDecorator;
import org.appops.service.job.JobExecService;
import org.appops.service.job.JobExecServiceImpl;
import org.appops.service.request.ServiceApiFilter;
import org.appops.service.store.RequestParameterStore;
import org.appops.service.store.RequestParameterStoreImpl;

public class ServiceBaseModule
extends BaseServletModule {
    @Override
    public void configureModule() {
        OperationDecorator decorator = new OperationDecorator();
        this.requestInjection(decorator);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(ServiceOp.class), decorator);
        this.bind(DeploymentConfig.class).annotatedWith(Names.named("CURRENT_DEPLOYMENT")).toProvider(CurrentDeploymentProvider.class).in(Singleton.class);
        this.bind(JobExecService.class).to(JobExecServiceImpl.class);
        this.bind(ServiceApiFilter.class).in(Singleton.class);
        this.filter("/*", new String[0]).through(ServiceApiFilter.class);
        this.bind(Client.class).toProvider(ClientProvider.class).in(RequestScoped.class);
        this.bind(ClientHandler.class).toProvider(ClientHandlerProvider.class).in(RequestScoped.class);
        this.bind(RequestParameterStore.class).to(RequestParameterStoreImpl.class).in(RequestScoped.class);
    }
}

