/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.job.pool;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Provider;
import org.appops.cache.event.ServiceEvent;
import org.appops.cache.slim.ServiceBus;
import org.appops.core.ClassPathAnalyser;
import org.appops.core.annotation.Config;
import org.appops.core.annotation.JobEntry;
import org.appops.core.job.token.JobToken;
import org.appops.service.event.JobEvent;
import org.appops.service.exception.InvocationException;
import org.appops.service.job.pool.JobPoolConfig;

public class JobPool {
    private ExecutorService execService;
    @Inject
    private Injector injector;
    private Provider<ServiceBus> serviceBus;

    @Inject
    public void setConfig(@Config JobPoolConfig config) {
        this.execService = this.initPool(config.getMaxPoolSize());
    }

    private ExecutorService initPool(int maxPoolSize) {
        return Executors.newFixedThreadPool(maxPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> Future<R> submitJob(final Object job, final Object[] parameters, final JobToken jobToken) {
        JobPool jobPool = this;
        synchronized (jobPool) {
            Future future = this.getExecService().submit(new Callable<R>(){

                @Override
                public R call() throws Exception {
                    Method method = JobPool.this.getJobEntryMethod(job.getClass());
                    JobPool.this.fireJobStartedEvent(jobToken);
                    Object returnValue = method.invoke(job, parameters);
                    JobPool.this.fireJobCompletedEvent(returnValue, jobToken);
                    return returnValue;
                }
            });
            return future;
        }
    }

    protected void fireJobStartedEvent(JobToken jobToken) {
        ServiceEvent serviceEvent = new ServiceEvent();
        serviceEvent.setEventType(JobEvent.class.getCanonicalName());
        serviceEvent.setEventStatus("STARTED");
        JobEvent jobEvent = new JobEvent();
        jobEvent.withToken(jobToken);
        serviceEvent.setEventData(jobEvent.getEventData());
        this.getServiceBus().get().fireEvent(serviceEvent);
    }

    protected void fireJobCompletedEvent(Object returnValue, JobToken jobToken) {
        ServiceEvent serviceEvent = new ServiceEvent();
        serviceEvent.setEventType(JobEvent.class.getCanonicalName());
        serviceEvent.setEventStatus("COMPLETED");
        JobEvent jobEvent = new JobEvent();
        jobEvent.withToken(jobToken);
        jobEvent.withJobResult(returnValue);
        serviceEvent.setEventData(jobEvent.getEventData());
        this.getServiceBus().get().fireEvent(serviceEvent);
    }

    private Method getJobEntryMethod(Class<?> jobClazz) {
        List<Method> methods = this.injector.getInstance(ClassPathAnalyser.class).getAnnotatedMethods(jobClazz, JobEntry.class);
        if (methods.isEmpty()) {
            throw new InvocationException("Method must have " + JobEntry.class.getName() + " annotation for execution.");
        }
        if (methods.size() > 1) {
            throw new InvocationException("Found more than one method with " + JobEntry.class.getName() + " annotation.");
        }
        return methods.get(0);
    }

    public ExecutorService getExecService() {
        return this.execService;
    }

    public Provider<ServiceBus> getServiceBus() {
        return this.serviceBus;
    }

    @Inject
    public void setServiceBus(Provider<ServiceBus> serviceBus) {
        this.serviceBus = serviceBus;
    }
}

