/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.request;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.appops.core.mime.MimeType;
import org.appops.core.response.BlobResponse;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.service.client.handler.ClientHandler;

public class RestResponseWriter {
    private Marshaller marshaller;
    private Provider<ClientHandler> clientHandlerProvider;

    public void sendResponse(HttpServletResponse response, Object result, String resultMimeType) throws IOException {
        Object resultRet = this.clientHandlerProvider.get().constructResult(result);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (((String)MimeType.XML.value()).equals(resultMimeType)) {
            this.sendXml(resultRet, response);
        } else if (((String)MimeType.TEXT.value()).equals(resultMimeType)) {
            this.sendText(result, response);
        } else if (((String)MimeType.BLOB.value()).equals(resultMimeType)) {
            this.sendBlob((BlobResponse)result, response);
        } else {
            this.sendJson(resultRet, response);
        }
    }

    private void sendBlob(BlobResponse result, HttpServletResponse response) throws IOException {
        response.setContentType(result.getMimeType());
        String fileName = result.getFileName();
        if (fileName != null && !fileName.isEmpty()) {
            response.setHeader("Content-Disposition", "filename=" + fileName);
        }
        Byte[] blobArrayObj = result.getByteArray();
        byte[] bytes = ArrayUtils.toPrimitive(blobArrayObj);
        response.setContentLength(bytes.length);
        response.getOutputStream().write(bytes);
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    void sendText(Object result, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        String text = String.valueOf(result);
        response.setContentType("text/plain");
        writer.println(text);
        writer.close();
    }

    void sendJson(Object result, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        response.setContentType("application/json");
        String json = "";
        json = result instanceof String ? (String)result : this.getMarshaller().marshall(result, DescriptorType.JSON);
        writer.println(json);
        writer.flush();
        writer.close();
    }

    void sendXml(Object result, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        response.setContentType("text/xml");
        String xml = this.getMarshaller().marshall(result, DescriptorType.XML);
        writer.println(xml);
        writer.flush();
        writer.close();
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Provider<ClientHandler> getClientHandlerProvider() {
        return this.clientHandlerProvider;
    }

    @Inject
    public void setClientHandlerProvider(Provider<ClientHandler> clientHandlerProvider) {
        this.clientHandlerProvider = clientHandlerProvider;
    }
}

