/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebListenerAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(WebListenerAnnotation.class);

    public WebListenerAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public WebListenerAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    @Override
    public void apply() {
        Class<?> clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        try {
            if (ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz) || HttpSessionIdListener.class.isAssignableFrom(clazz)) {
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOrigin(clazz.getName() + ".listener") == Origin.NotSet) {
                    ListenerHolder h2 = this._context.getServletHandler().newListenerHolder(new Source(Source.Origin.ANNOTATION, clazz.getName()));
                    h2.setHeldClass(clazz);
                    this._context.getServletHandler().addListener(h2);
                }
            } else {
                LOG.warn(clazz.getName() + " does not implement one of the servlet listener interfaces", new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }
}

