/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restexpress.common.query.QueryRange;
import org.restexpress.serialization.SerializationSettings;

public class Response {
    private static final String CONTENT_RANGE_HEADER_NAME = "Content-Range";
    private HttpResponseStatus responseCode = HttpResponseStatus.OK;
    private Object body;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private boolean isSerialized = true;
    private Throwable exception = null;
    private SerializationSettings serializationSettings;

    public Object getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.getBody() != null;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String getHeader(String name) {
        List<String> list = this.headers.get(name);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List<String> getHeaders(String name) {
        return this.headers.get(name);
    }

    public boolean hasHeader(String name) {
        return this.getHeader(name) != null;
    }

    public boolean hasHeaders() {
        return !this.headers.isEmpty();
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public void addHeader(String name, String value) {
        List<String> list = this.headers.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(name, list);
        }
        list.add(value);
    }

    public void addRangeHeader(QueryRange range, long count) {
        this.addHeader(CONTENT_RANGE_HEADER_NAME, range.asContentRange(count));
    }

    public void addLocationHeader(String url) {
        this.addHeader("Location", url);
    }

    public void setCollectionResponse(QueryRange queryRange, int size, long count) {
        QueryRange range = queryRange.clone();
        if (count < 0L) {
            this.addRangeHeader(range, count);
            return;
        }
        if (range.isOutside(size, count)) {
            this.setResponseCode(416);
            range.setOffset(0L);
            range.setLimitViaEnd(Math.min(count - 1L, (long)range.getLimit()));
        } else if (range.extendsBeyond(size, count)) {
            if (count == 0L && range.getOffset() > 0L) {
                this.setResponseCode(416);
                range.setOffset(0L);
                range.setLimitViaEnd(0L);
            } else {
                range.setLimitViaEnd(count > 1L ? count - 1L : 0L);
            }
            if (count > 0L && !range.spans(size, count)) {
                this.setResponseCode(206);
            }
        } else if (range.isInside(size, count)) {
            this.setResponseCode(206);
        }
        this.addRangeHeader(range, count);
    }

    public void setResponseCode(int value) {
        this.setResponseStatus(HttpResponseStatus.valueOf(value));
    }

    public void setResponseStatus(HttpResponseStatus status) {
        this.responseCode = status;
    }

    public void setResponseCreated() {
        this.setResponseStatus(HttpResponseStatus.CREATED);
    }

    public void setResponseNoContent() {
        this.setResponseStatus(HttpResponseStatus.NO_CONTENT);
    }

    public HttpResponseStatus getResponseStatus() {
        return this.responseCode;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentType(String contentType) {
        List<String> list = this.headers.get("Content-Type");
        if (list != null && !list.isEmpty()) {
            list.clear();
            list.add(contentType);
        } else if (list == null) {
            this.addHeader("Content-Type", contentType);
        }
    }

    public boolean isSerialized() {
        return this.isSerialized;
    }

    public void setIsSerialized(boolean value) {
        this.isSerialized = value;
    }

    public void noSerialization() {
        this.setIsSerialized(false);
    }

    public void useSerialization() {
        this.setIsSerialized(true);
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setSerializationSettings(SerializationSettings settings) {
        this.serializationSettings = settings;
    }

    public boolean hasSerializationSettings() {
        return this.serializationSettings != null;
    }

    public String getMediaType() {
        return this.hasSerializationSettings() ? this.serializationSettings.getMediaType() : null;
    }

    public SerializationSettings getSerializationSettings() {
        return this.serializationSettings;
    }
}

