/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.restexpress.ServerBootstrapFactory;
import org.restexpress.domain.metadata.RouteMetadata;
import org.restexpress.domain.metadata.ServerMetadata;
import org.restexpress.exception.DefaultExceptionMapper;
import org.restexpress.exception.ExceptionMapping;
import org.restexpress.exception.ServiceException;
import org.restexpress.pipeline.DefaultRequestHandler;
import org.restexpress.pipeline.MessageObserver;
import org.restexpress.pipeline.PipelineInitializer;
import org.restexpress.pipeline.Postprocessor;
import org.restexpress.pipeline.Preprocessor;
import org.restexpress.plugin.Plugin;
import org.restexpress.response.DefaultHttpResponseWriter;
import org.restexpress.route.RouteBuilder;
import org.restexpress.route.RouteDeclaration;
import org.restexpress.route.RouteResolver;
import org.restexpress.route.parameterized.ParameterizedRouteBuilder;
import org.restexpress.route.regex.RegexRouteBuilder;
import org.restexpress.serialization.DefaultSerializationProvider;
import org.restexpress.serialization.SerializationProvider;
import org.restexpress.settings.RouteDefaults;
import org.restexpress.settings.ServerSettings;
import org.restexpress.settings.SocketSettings;
import org.restexpress.util.Callback;
import org.restexpress.util.DefaultShutdownHook;

public class RestExpress {
    private static final ChannelGroup allChannels = new DefaultChannelGroup("RestExpress", GlobalEventExecutor.INSTANCE);
    public static final String DEFAULT_NAME = "RestExpress";
    public static final int DEFAULT_PORT = 8081;
    private static SerializationProvider DEFAULT_SERIALIZATION_PROVIDER = null;
    private SocketSettings socketSettings = new SocketSettings();
    private ServerSettings serverSettings = new ServerSettings();
    private RouteDefaults routeDefaults = new RouteDefaults();
    private boolean enforceHttpSpec = false;
    private boolean useSystemOut;
    private ServerBootstrapFactory bootstrapFactory = new ServerBootstrapFactory();
    private List<MessageObserver> messageObservers = new ArrayList<MessageObserver>();
    private List<Preprocessor> preprocessors = new ArrayList<Preprocessor>();
    private List<Postprocessor> postprocessors = new ArrayList<Postprocessor>();
    private List<Postprocessor> finallyProcessors = new ArrayList<Postprocessor>();
    private ExceptionMapping exceptionMap = new DefaultExceptionMapper();
    private List<Plugin> plugins = new ArrayList<Plugin>();
    private RouteDeclaration routeDeclarations = new RouteDeclaration();
    private SSLContext sslContext = null;
    private SerializationProvider serializationProvider = null;

    public static void setSerializationProvider(SerializationProvider provider) {
        RestExpress.setDefaultSerializationProvider(provider);
    }

    public static SerializationProvider getSerializationProvider() {
        return RestExpress.getDefaultSerializationProvider();
    }

    public static void setDefaultSerializationProvider(SerializationProvider provider) {
        DEFAULT_SERIALIZATION_PROVIDER = provider;
    }

    public static SerializationProvider getDefaultSerializationProvider() {
        if (DEFAULT_SERIALIZATION_PROVIDER == null) {
            DEFAULT_SERIALIZATION_PROVIDER = new DefaultSerializationProvider();
        }
        return DEFAULT_SERIALIZATION_PROVIDER;
    }

    public RestExpress serializationProvider(SerializationProvider provider) {
        this.serializationProvider = provider;
        return this;
    }

    public SerializationProvider serializationProvider() {
        if (this.serializationProvider == null) {
            this.serializationProvider(RestExpress.getDefaultSerializationProvider());
        }
        return this.serializationProvider;
    }

    public RestExpress() {
        this.setName(DEFAULT_NAME);
        this.useSystemOut();
    }

    public RestExpress setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public String getBaseUrl() {
        return this.routeDefaults.getBaseUrl();
    }

    public RestExpress setBaseUrl(String baseUrl) {
        this.routeDefaults.setBaseUrl(baseUrl);
        return this;
    }

    public String getName() {
        return this.serverSettings.getName();
    }

    public RestExpress setName(String name) {
        this.serverSettings.setName(name);
        return this;
    }

    public int getPort() {
        return this.serverSettings.getPort();
    }

    public RestExpress setPort(int port) {
        this.serverSettings.setPort(port);
        return this;
    }

    public String getHostname() {
        return this.serverSettings.getHostname();
    }

    public boolean hasHostname() {
        return this.serverSettings.hasHostname();
    }

    public void setHostname(String hostname) {
        this.serverSettings.setHostname(hostname);
    }

    public RestExpress addMessageObserver(MessageObserver observer) {
        if (!this.messageObservers.contains(observer)) {
            this.messageObservers.add(observer);
        }
        return this;
    }

    public List<MessageObserver> getMessageObservers() {
        return Collections.unmodifiableList(this.messageObservers);
    }

    public RestExpress addPreprocessor(Preprocessor processor) {
        if (!this.preprocessors.contains(processor)) {
            this.preprocessors.add(processor);
        }
        return this;
    }

    public List<Preprocessor> getPreprocessors() {
        return Collections.unmodifiableList(this.preprocessors);
    }

    public RestExpress addPostprocessor(Postprocessor processor) {
        if (!this.postprocessors.contains(processor)) {
            this.postprocessors.add(processor);
        }
        return this;
    }

    public List<Postprocessor> getPostprocessors() {
        return Collections.unmodifiableList(this.postprocessors);
    }

    public RestExpress addFinallyProcessor(Postprocessor processor) {
        if (!this.finallyProcessors.contains(processor)) {
            this.finallyProcessors.add(processor);
        }
        return this;
    }

    public List<Postprocessor> getFinallyProcessors() {
        return Collections.unmodifiableList(this.finallyProcessors);
    }

    public boolean shouldUseSystemOut() {
        return this.useSystemOut;
    }

    public RestExpress setUseSystemOut(boolean useSystemOut) {
        this.useSystemOut = useSystemOut;
        return this;
    }

    public RestExpress setEnforceHttpSpec(boolean enforceHttpSpec) {
        this.enforceHttpSpec = enforceHttpSpec;
        return this;
    }

    public RestExpress enforceHttpSpec() {
        this.setEnforceHttpSpec(true);
        return this;
    }

    public RestExpress useSystemOut() {
        this.setUseSystemOut(true);
        return this;
    }

    public RestExpress noSystemOut() {
        this.setUseSystemOut(false);
        return this;
    }

    public boolean useTcpNoDelay() {
        return this.socketSettings.useTcpNoDelay();
    }

    public RestExpress setUseTcpNoDelay(boolean useTcpNoDelay) {
        this.socketSettings.setUseTcpNoDelay(useTcpNoDelay);
        return this;
    }

    public boolean useKeepAlive() {
        return this.serverSettings.isKeepAlive();
    }

    public RestExpress setKeepAlive(boolean useKeepAlive) {
        this.serverSettings.setKeepAlive(useKeepAlive);
        return this;
    }

    public boolean shouldReuseAddress() {
        return this.serverSettings.isReuseAddress();
    }

    public RestExpress setReuseAddress(boolean reuseAddress) {
        this.serverSettings.setReuseAddress(reuseAddress);
        return this;
    }

    public int getSoLinger() {
        return this.socketSettings.getSoLinger();
    }

    public RestExpress setSoLinger(int soLinger) {
        this.socketSettings.setSoLinger(soLinger);
        return this;
    }

    public int getReceiveBufferSize() {
        return this.socketSettings.getReceiveBufferSize();
    }

    public RestExpress setReceiveBufferSize(int receiveBufferSize) {
        this.socketSettings.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public int getConnectTimeoutMillis() {
        return this.socketSettings.getConnectTimeoutMillis();
    }

    public RestExpress setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.socketSettings.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    public RestExpress alias(String elementName, Class<?> theClass) {
        this.routeDefaults.addXmlAlias(elementName, theClass);
        return this;
    }

    public <T extends Exception, U extends ServiceException> RestExpress mapException(Class<T> from, Class<U> to) {
        this.exceptionMap.map(from, to);
        return this;
    }

    public RestExpress setExceptionMap(ExceptionMapping mapping) {
        this.exceptionMap = mapping;
        return this;
    }

    public int getIoThreadCount() {
        return this.serverSettings.getIoThreadCount();
    }

    public RestExpress setIoThreadCount(int value) {
        this.serverSettings.setIoThreadCount(value);
        return this;
    }

    public int getExecutorThreadCount() {
        return this.serverSettings.getExecutorThreadPoolSize();
    }

    public RestExpress setExecutorThreadCount(int value) {
        this.serverSettings.setExecutorThreadPoolSize(value);
        return this;
    }

    public RestExpress setMaxContentSize(int size) {
        this.serverSettings.setMaxContentSize(size);
        return this;
    }

    public void iterateRouteBuilders(Callback<RouteBuilder> callback) {
        this.routeDeclarations.iterateRouteBuilders(callback);
    }

    public Channel bind() {
        return this.bind(this.getPort() > 0 ? this.getPort() : 8081);
    }

    public ChannelHandler buildRequestHandler() {
        DefaultRequestHandler requestHandler = new DefaultRequestHandler(this.createRouteResolver(), this.serializationProvider(), new DefaultHttpResponseWriter(), this.enforceHttpSpec);
        requestHandler.addMessageObserver(this.messageObservers.toArray(new MessageObserver[0]));
        requestHandler.setExceptionMap(this.exceptionMap);
        this.addPreprocessors(requestHandler);
        this.addPostprocessors(requestHandler);
        this.addFinallyProcessors(requestHandler);
        return requestHandler;
    }

    public Channel bind(int port) {
        this.setPort(port);
        if (this.hasHostname()) {
            return this.bind(new InetSocketAddress(this.getHostname(), port));
        }
        return this.bind(new InetSocketAddress(port));
    }

    public Channel bind(String hostname, int port) {
        this.setPort(port);
        return this.bind(new InetSocketAddress(hostname, port));
    }

    public Channel bind(InetSocketAddress ipAddress) {
        ServerBootstrap bootstrap = this.bootstrapFactory.newServerBootstrap(this.getIoThreadCount());
        bootstrap.childHandler(new PipelineInitializer().setExecutionHandler(this.initializeExecutorGroup()).addRequestHandler(this.buildRequestHandler()).setSSLContext(this.sslContext).setMaxContentLength(this.serverSettings.getMaxContentSize()));
        this.setBootstrapOptions(bootstrap);
        if (this.shouldUseSystemOut()) {
            System.out.println(this.getName() + " server listening on port " + ipAddress.toString());
        }
        Channel channel = bootstrap.bind(ipAddress).channel();
        allChannels.add(channel);
        this.bindPlugins();
        return channel;
    }

    private EventExecutorGroup initializeExecutorGroup() {
        if (this.getExecutorThreadCount() > 0) {
            return new DefaultEventExecutorGroup(this.getExecutorThreadCount());
        }
        return null;
    }

    private void setBootstrapOptions(ServerBootstrap bootstrap) {
        bootstrap.option(ChannelOption.SO_KEEPALIVE, this.useKeepAlive());
        bootstrap.option(ChannelOption.SO_BACKLOG, 1024);
        bootstrap.option(ChannelOption.TCP_NODELAY, this.useTcpNoDelay());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, this.serverSettings.isKeepAlive());
        bootstrap.option(ChannelOption.SO_REUSEADDR, this.shouldReuseAddress());
        bootstrap.option(ChannelOption.SO_LINGER, this.getSoLinger());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.getConnectTimeoutMillis());
        bootstrap.option(ChannelOption.SO_RCVBUF, this.getReceiveBufferSize());
        bootstrap.option(ChannelOption.MAX_MESSAGES_PER_READ, Integer.MAX_VALUE);
        bootstrap.childOption(ChannelOption.ALLOCATOR, new PooledByteBufAllocator(true));
        bootstrap.childOption(ChannelOption.MAX_MESSAGES_PER_READ, Integer.MAX_VALUE);
        bootstrap.childOption(ChannelOption.SO_RCVBUF, this.getReceiveBufferSize());
        bootstrap.childOption(ChannelOption.SO_REUSEADDR, this.shouldReuseAddress());
    }

    public void awaitShutdown() {
        Runtime.getRuntime().addShutdownHook(new DefaultShutdownHook(this));
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (!interrupted);
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean shouldWait) {
        ChannelGroupFuture channelFuture = allChannels.close();
        this.bootstrapFactory.shutdownGracefully(shouldWait);
        channelFuture.awaitUninterruptibly();
        this.shutdownPlugins();
    }

    private RouteResolver createRouteResolver() {
        return new RouteResolver(this.routeDeclarations.createRouteMapping(this.routeDefaults));
    }

    public ServerMetadata getRouteMetadata() {
        ServerMetadata m3 = new ServerMetadata();
        m3.setName(this.getName());
        m3.setPort(this.getPort());
        m3.addAllRoutes(this.routeDeclarations.getMetadata());
        return m3;
    }

    public Map<String, String> getRouteUrlsByName() {
        final HashMap<String, String> urlsByName = new HashMap<String, String>();
        this.iterateRouteBuilders(new Callback<RouteBuilder>(){

            @Override
            public void process(RouteBuilder routeBuilder) {
                RouteMetadata route = routeBuilder.asMetadata();
                if (route.getName() != null) {
                    urlsByName.put(route.getName(), RestExpress.this.getBaseUrl() + route.getUri().getPattern().replace(".{format}", ""));
                }
            }
        });
        return urlsByName;
    }

    public RestExpress registerPlugin(Plugin plugin) {
        if (!this.plugins.contains(plugin)) {
            this.plugins.add(plugin);
            plugin.register(this);
        }
        return this;
    }

    private void bindPlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.bind(this);
        }
    }

    private void shutdownPlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.shutdown(this);
        }
    }

    private void addPreprocessors(DefaultRequestHandler requestHandler) {
        for (Preprocessor processor : this.getPreprocessors()) {
            requestHandler.addPreprocessor(processor);
        }
    }

    private void addPostprocessors(DefaultRequestHandler requestHandler) {
        for (Postprocessor processor : this.getPostprocessors()) {
            requestHandler.addPostprocessor(processor);
        }
    }

    private void addFinallyProcessors(DefaultRequestHandler requestHandler) {
        for (Postprocessor processor : this.getFinallyProcessors()) {
            requestHandler.addFinallyProcessor(processor);
        }
    }

    public ParameterizedRouteBuilder uri(String uriPattern, Object controller) {
        return this.routeDeclarations.uri(uriPattern, controller, this.routeDefaults);
    }

    public RegexRouteBuilder regex(String uriPattern, Object controller) {
        return this.routeDeclarations.regex(uriPattern, controller, this.routeDefaults);
    }
}

