/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;

public class ServerBootstrapFactory {
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public ServerBootstrap newServerBootstrap(int ioThreadCount) {
        if (Epoll.isAvailable()) {
            return this.newEpollServerBootstrap(ioThreadCount);
        }
        return this.newNioServerBootstrap(ioThreadCount);
    }

    public void shutdownGracefully(boolean shouldWait) {
        Future<?> workerFuture = this.workerGroup.shutdownGracefully();
        Future<?> bossFuture = this.bossGroup.shutdownGracefully();
        if (shouldWait) {
            workerFuture.awaitUninterruptibly();
            bossFuture.awaitUninterruptibly();
        }
    }

    private ServerBootstrap newNioServerBootstrap(int ioThreadCount) {
        if (ioThreadCount > 0) {
            this.bossGroup = new NioEventLoopGroup(ioThreadCount);
            this.workerGroup = new NioEventLoopGroup(ioThreadCount);
        } else {
            this.bossGroup = new NioEventLoopGroup();
            this.workerGroup = new NioEventLoopGroup();
        }
        return (ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
    }

    private ServerBootstrap newEpollServerBootstrap(int ioThreadCount) {
        if (ioThreadCount > 0) {
            this.bossGroup = new EpollEventLoopGroup(ioThreadCount);
            this.workerGroup = new EpollEventLoopGroup(ioThreadCount);
        } else {
            this.bossGroup = new EpollEventLoopGroup();
            this.workerGroup = new EpollEventLoopGroup();
        }
        return (ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(EpollServerSocketChannel.class);
    }
}

