/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.pipeline;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.pipeline.MessageObserver;

public class SimpleConsoleLogMessageObserver
extends MessageObserver {
    private Map<String, Timer> timers = new ConcurrentHashMap<String, Timer>();

    @Override
    protected void onReceived(Request request, Response response) {
        this.timers.put(request.getCorrelationId(), new Timer());
    }

    @Override
    protected void onException(Throwable exception, Request request, Response response) {
        System.out.println(request.getEffectiveHttpMethod().toString() + " " + request.getUrl() + " threw exception: " + exception.getClass().getSimpleName());
        exception.printStackTrace();
    }

    @Override
    protected void onSuccess(Request request, Response response) {
    }

    @Override
    protected void onComplete(Request request, Response response) {
        Timer timer = this.timers.remove(request.getCorrelationId());
        if (timer != null) {
            timer.stop();
        }
        StringBuffer sb = new StringBuffer(request.getEffectiveHttpMethod().toString());
        sb.append(" ");
        sb.append(request.getUrl());
        if (timer != null) {
            sb.append(" responded with ");
            sb.append(response.getResponseStatus().toString());
            sb.append(" in ");
            sb.append(timer.toString());
        } else {
            sb.append(" responded with ");
            sb.append(response.getResponseStatus().toString());
            sb.append(" (no timer found)");
        }
        System.out.println(sb.toString());
    }

    private static class Timer {
        private long startMillis = System.currentTimeMillis();
        private long stopMillis = 0L;

        public void stop() {
            this.stopMillis = System.currentTimeMillis();
        }

        public String toString() {
            long stopTime = this.stopMillis == 0L ? System.currentTimeMillis() : this.stopMillis;
            return String.valueOf(stopTime - this.startMillis) + "ms";
        }
    }
}

