/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.plugin;

import org.restexpress.RestExpress;
import org.restexpress.plugin.Plugin;

public abstract class AbstractPlugin
implements Plugin {
    private boolean isRegistered;

    @Override
    public AbstractPlugin register(RestExpress server) {
        if (!this.isRegistered()) {
            this.setRegistered(true);
            server.registerPlugin(this);
        }
        return this;
    }

    @Override
    public void bind(RestExpress server) {
    }

    @Override
    public void shutdown(RestExpress server) {
        this.setRegistered(false);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (AbstractPlugin.class.isAssignableFrom(other.getClass())) {
            return this.equals((AbstractPlugin)other);
        }
        return false;
    }

    public boolean equals(AbstractPlugin plugin) {
        if (plugin == null) {
            return false;
        }
        return this.getClass().getSimpleName().equals(plugin.getClass().getSimpleName());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ 0x11;
    }

    protected boolean isRegistered() {
        return this.isRegistered;
    }

    protected void setRegistered(boolean value) {
        this.isRegistered = value;
    }
}

