/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restexpress.plugin.AbstractPlugin;
import org.restexpress.route.RouteBuilder;

public abstract class RoutePlugin
extends AbstractPlugin {
    private List<String> flags = new ArrayList<String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public RoutePlugin flag(String flagValue) {
        if (!this.flags.contains(flagValue)) {
            this.flags.add(flagValue);
        }
        return this;
    }

    public List<String> flags() {
        return Collections.unmodifiableList(this.flags);
    }

    public RoutePlugin parameter(String name, Object value) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, value);
        }
        return this;
    }

    public Map<String, Object> parameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    protected void applyFlags(RouteBuilder routeBuilder) {
        for (String flag : this.flags) {
            routeBuilder.flag(flag);
        }
    }

    protected void applyParameters(RouteBuilder routeBuilder) {
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            routeBuilder.parameter(entry.getKey(), entry.getValue());
        }
    }
}

