/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.query;

import java.util.Arrays;
import java.util.List;
import org.restexpress.Request;
import org.restexpress.common.query.QueryOrder;
import org.restexpress.common.util.StringUtils;
import org.restexpress.exception.BadRequestException;

public abstract class QueryOrders {
    private static final String SORT_HEADER_NAME = "sort";
    private static final String SORT_SEPARATOR = "\\|";

    public static QueryOrder parseFrom(Request request) {
        return QueryOrders.parseFrom(request, (List<String>)null);
    }

    public static QueryOrder parseFrom(Request request, String ... allowedProperties) {
        return QueryOrders.parseFrom(request, Arrays.asList(allowedProperties));
    }

    public static QueryOrder parseFrom(Request request, List<String> allowedProperties) {
        String sortString = request.getHeader(SORT_HEADER_NAME);
        if (sortString == null || sortString.trim().isEmpty()) {
            return new QueryOrder();
        }
        String[] strings = sortString.split(SORT_SEPARATOR);
        QueryOrders.enforceAllowedProperties(allowedProperties, strings);
        return new QueryOrder(strings);
    }

    private static void enforceAllowedProperties(List<String> allowedProperties, String[] requestedProperties) {
        int i;
        if (requestedProperties == null) {
            return;
        }
        if (allowedProperties != null && (i = 0) < requestedProperties.length) {
            String requested = requestedProperties[i++];
            for (String allowed : allowedProperties) {
                if (!requested.endsWith(allowed)) continue;
                return;
            }
            throw new BadRequestException(requested + " is not a supported sort field. Supported sort fields are: " + StringUtils.join(", ", allowedProperties));
        }
    }
}

