/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.response;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.restexpress.ContentType;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.response.HttpResponseWriter;
import org.restexpress.util.HttpSpecification;

public class DefaultHttpResponseWriter
implements HttpResponseWriter {
    @Override
    public void write(ChannelHandlerContext ctx, Request request, Response response) {
        DefaultFullHttpResponse httpResponse = response.hasBody() && HttpSpecification.isContentAllowed(response) ? new DefaultFullHttpResponse(request.getHttpVersion(), this.getHttpResponseStatusFrom(request, response), this.getResponseBodyByteBuf(response)) : new DefaultFullHttpResponse(request.getHttpVersion(), this.getHttpResponseStatusFrom(request, response));
        this.addHeaders(response, httpResponse);
        if (request.isKeepAlive()) {
            if (HttpSpecification.isContentLengthAllowed(response)) {
                httpResponse.headers().set("Content-Length", (Object)String.valueOf(httpResponse.content().readableBytes()));
            }
            if (request.isHttpVersion1_0()) {
                httpResponse.headers().add("Connection", (Object)"Keep-Alive");
            }
            this.enforceEmptyHeadResponseBody(request, httpResponse);
            ctx.channel().write(httpResponse).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        } else {
            httpResponse.headers().set("Connection", (Object)"close");
            this.enforceEmptyHeadResponseBody(request, httpResponse);
            ctx.channel().write(httpResponse).addListener(ChannelFutureListener.CLOSE);
        }
    }

    private ByteBuf getResponseBodyByteBuf(Response response) {
        return ByteBuf.class.isAssignableFrom(response.getBody().getClass()) ? Unpooled.wrappedBuffer((ByteBuf)response.getBody()) : Unpooled.wrappedBuffer(response.getBody().toString().getBytes(ContentType.CHARSET));
    }

    private HttpResponseStatus getHttpResponseStatusFrom(Request request, Response response) {
        return request.getHeader("_ignore_http_status") == null ? response.getResponseStatus() : HttpResponseStatus.OK;
    }

    private void addHeaders(Response response, HttpResponse httpResponse) {
        for (String name : response.getHeaderNames()) {
            for (String value : response.getHeaders(name)) {
                httpResponse.headers().add(name, (Object)value);
            }
        }
    }

    private void enforceEmptyHeadResponseBody(Request request, FullHttpResponse httpResponse) {
        if (request.getHttpMethod() == HttpMethod.HEAD) {
            httpResponse.content().clear();
        }
    }
}

