/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.restexpress.contenttype.MediaRange;
import org.restexpress.contenttype.MediaTypeParser;
import org.restexpress.serialization.SerializationProcessor;

public abstract class AbstractSerializationProcessor
implements SerializationProcessor {
    private List<String> supportedFormats = new ArrayList<String>();
    private List<MediaRange> supportedMediaRanges = new ArrayList<MediaRange>();

    public AbstractSerializationProcessor() {
    }

    public AbstractSerializationProcessor(List<String> supportedFormats, List<MediaRange> supportedMediaRanges) {
        this.setSupportedFormats(supportedFormats);
        this.setSupportedMediaRanges(supportedMediaRanges);
    }

    public AbstractSerializationProcessor addSupportedFormat(String format) {
        if (!this.supportedFormats.contains(format)) {
            this.supportedFormats.add(format);
        }
        return this;
    }

    @Override
    public List<String> getSupportedFormats() {
        return Collections.unmodifiableList(this.supportedFormats);
    }

    public void setSupportedFormats(List<String> supportedFormats) {
        this.supportedFormats.clear();
        this.supportedFormats.addAll(supportedFormats);
    }

    public void addSupportedMediaTypes(String mediaTypes) {
        this.addSupportedMediaRanges(MediaTypeParser.parse(mediaTypes));
    }

    public void addSupportedMediaRange(MediaRange mediaRange) {
        if (!this.supportedMediaRanges.contains(mediaRange)) {
            this.supportedMediaRanges.add(mediaRange);
        }
    }

    public void addSupportedMediaRanges(List<MediaRange> mediaRanges) {
        for (MediaRange mediaRange : mediaRanges) {
            this.addSupportedMediaRange(mediaRange);
        }
    }

    @Override
    public List<MediaRange> getSupportedMediaRanges() {
        return this.supportedMediaRanges;
    }

    public void setSupportedMediaRanges(List<MediaRange> mediaRanges) {
        this.supportedMediaRanges.clear();
        this.supportedMediaRanges.addAll(mediaRanges);
    }
}

