/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.serialization.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.restexpress.ContentType;
import org.restexpress.domain.JsendResultWrapper;
import org.restexpress.serialization.xml.XmlSerializationProcessor;
import org.restexpress.serialization.xml.XstreamTimestampConverter;

public class XstreamXmlProcessor
extends XmlSerializationProcessor {
    private static final byte[] EMPTY_STRING_BYTES = "".getBytes(ContentType.CHARSET);
    private XStream xstream;
    private Map<Class<?>, String> aliases = new HashMap();
    private boolean shouldAutoAlias = true;

    public XstreamXmlProcessor() {
        this("xml");
    }

    public XstreamXmlProcessor(String format) {
        this(new XStream(), format);
        this.xstream.registerConverter(new XstreamTimestampConverter());
        this.xstream.alias("list", ArrayList.class);
        this.xstream.alias("response", JsendResultWrapper.class);
    }

    public XstreamXmlProcessor(XStream xstream, String format) {
        super(format);
        this.xstream = xstream;
        this.shouldAutoAlias = false;
    }

    protected XStream getXStream() {
        return this.xstream;
    }

    @Override
    public void alias(String name, Class<?> type) {
        this.xstream.alias(name, type);
    }

    public void registerConverter(SingleValueConverter converter) {
        this.xstream.registerConverter(converter);
    }

    @Override
    public ByteBuffer serialize(Object object) {
        if (object == null) {
            return ByteBuffer.wrap(EMPTY_STRING_BYTES);
        }
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        this.xstream.toXML(object, b);
        return ByteBuffer.wrap(b.toByteArray());
    }

    @Override
    public <T> T deserialize(String xml, Class<T> type) {
        if (xml == null || xml.trim().isEmpty()) {
            return null;
        }
        if (this.shouldAutoAlias) {
            this.addAliasIfNecessary(type);
        }
        return (T)this.xstream.fromXML(xml);
    }

    @Override
    public <T> T deserialize(ByteBuf xml, Class<T> type) {
        if (!xml.isReadable()) {
            return null;
        }
        return (T)this.xstream.fromXML(new ByteBufInputStream(xml));
    }

    private void addAliasIfNecessary(Class<?> type) {
        if (!this.aliases.containsKey(type)) {
            String name = type.getSimpleName().trim();
            if ("[]".equals(name) || "".equals(name)) {
                return;
            }
            this.xstream.alias(name, type);
        }
    }
}

