/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.event;

import org.appops.cache.event.ServiceEvent;
import org.appops.core.job.token.JobToken;

/**
 * An event class which contains Job related information like Job status, job result etc.
 *
 * @author suraj
 * @version $Id: $Id
 */
public class JobEvent extends ServiceEvent {

  /** Constant <code>STARTED="STARTED"</code> */
  public static final String STARTED = "STARTED";
  /** Constant <code>COMPLETED="COMPLETED"</code> */
  public static final String COMPLETED = "COMPLETED";
  private static final String JOB_RESULT = "JOB_RESULT";
  private static final String JOB_TOKEN = "JOB_TOKEN";

  /**
   * default constructor.
   */
  public JobEvent() {

  }

  /**
   * <p>
   * withJobResult.
   * </p>
   *
   * @param result a {@link java.lang.Object} object.
   */
  public void withJobResult(Object result) {
    addEventData(JOB_RESULT, result);
  }

  /**
   * <p>
   * jobResult.
   * </p>
   *
   * @param <T> a T object.
   * @return a T object.
   */
  public <T> T jobResult() {
    return getValue(JOB_RESULT);
  }

  /**
   * <p>
   * withToken.
   * </p>
   *
   * @param jobToken a {@link org.appops.core.job.token.JobToken} object.
   */
  public void withToken(JobToken jobToken) {
    addEventData(JOB_TOKEN, jobToken);
  }

  /**
   * <p>
   * getJobEventStatus.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getJobEventStatus() {
    return getEventStatus();
  }

  /**
   * Fetch job token from data map .
   *
   * @param <T> type of job token
   * @return {@link org.appops.core.job.token.JobToken}
   */
  public <T> T jobToken() {
    return getValue(JobEvent.JOB_TOKEN);

  }

}
