/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusChecker {
    StatusManager sm;

    public StatusChecker(StatusManager sm) {
        this.sm = sm;
    }

    public StatusChecker(Context context) {
        this.sm = context.getStatusManager();
    }

    public boolean hasXMLParsingErrors(long threshold) {
        return this.containsMatch(threshold, 2, "XML_PARSING");
    }

    public boolean noXMLParsingErrorsOccurred(long threshold) {
        return !this.hasXMLParsingErrors(threshold);
    }

    public int getHighestLevel(long threshold) {
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        int maxLevel = 0;
        for (Status s2 : filteredList) {
            if (s2.getLevel() <= maxLevel) continue;
            maxLevel = s2.getLevel();
        }
        return maxLevel;
    }

    public boolean isErrorFree(long threshold) {
        return 2 > this.getHighestLevel(threshold);
    }

    public boolean containsMatch(long threshold, int level, String regex) {
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        Pattern p = Pattern.compile(regex);
        for (Status status : filteredList) {
            String msg;
            Matcher matcher;
            if (level != status.getLevel() || !(matcher = p.matcher(msg = status.getMessage())).lookingAt()) continue;
            return true;
        }
        return false;
    }

    public boolean containsMatch(int level, String regex) {
        return this.containsMatch(0L, level, regex);
    }

    public boolean containsMatch(String regex) {
        Pattern p = Pattern.compile(regex);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String msg = status.getMessage();
            Matcher matcher = p.matcher(msg);
            if (!matcher.lookingAt()) continue;
            return true;
        }
        return false;
    }

    public int matchCount(String regex) {
        int count = 0;
        Pattern p = Pattern.compile(regex);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String msg = status.getMessage();
            Matcher matcher = p.matcher(msg);
            if (!matcher.lookingAt()) continue;
            ++count;
        }
        return count;
    }

    public boolean containsException(Class exceptionType) {
        for (Status status : this.sm.getCopyOfStatusList()) {
            Throwable t = status.getThrowable();
            if (t == null || !t.getClass().getName().equals(exceptionType.getName())) continue;
            return true;
        }
        return false;
    }

    public long timeOfLastReset() {
        List<Status> statusList = this.sm.getCopyOfStatusList();
        if (statusList == null) {
            return -1L;
        }
        int len = statusList.size();
        for (int i = len - 1; i >= 0; --i) {
            Status s2 = statusList.get(i);
            if (!"Will reset and reconfigure context ".equals(s2.getMessage())) continue;
            return s2.getDate();
        }
        return -1L;
    }
}

