/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.osgi;

import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;
import org.apache.logging.log4j.core.impl.Log4jProvider;
import org.apache.logging.log4j.core.osgi.BundleContextSelector;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWiring;

public final class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AtomicReference<BundleContext> contextRef = new AtomicReference();
    ServiceRegistration provideRegistration = null;

    public void start(BundleContext context) throws Exception {
        Log4jProvider provider = new Log4jProvider();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("APIVersion", "2.60");
        this.provideRegistration = context.registerService(Provider.class.getName(), (Object)provider, props);
        if (PropertiesUtil.getProperties().getStringProperty("Log4jContextSelector") == null) {
            System.setProperty("Log4jContextSelector", BundleContextSelector.class.getName());
        }
        if (this.contextRef.compareAndSet(null, context)) {
            context.addBundleListener((BundleListener)this);
            Activator.scanInstalledBundlesForPlugins(context);
        }
    }

    private static void scanInstalledBundlesForPlugins(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle2 : bundles = context.getBundles()) {
            Activator.scanBundleForPlugins(bundle2);
        }
    }

    private static void scanBundleForPlugins(Bundle bundle2) {
        long bundleId = bundle2.getBundleId();
        if (bundle2.getState() == 32 && bundleId != 0L) {
            LOGGER.trace("Scanning bundle [{}, id=%d] for plugins.", (Object)bundle2.getSymbolicName(), (Object)bundleId);
            PluginRegistry.getInstance().loadFromBundle(bundleId, ((BundleWiring)bundle2.adapt(BundleWiring.class)).getClassLoader());
        }
    }

    private static void stopBundlePlugins(Bundle bundle2) {
        LOGGER.trace("Stopping bundle [{}] plugins.", (Object)bundle2.getSymbolicName());
        PluginRegistry.getInstance().clearBundlePlugins(bundle2.getBundleId());
    }

    public void stop(BundleContext context) throws Exception {
        this.provideRegistration.unregister();
        this.contextRef.compareAndSet(context, null);
        LogManager.shutdown();
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                Activator.scanBundleForPlugins(event.getBundle());
                break;
            }
            case 256: {
                Activator.stopBundlePlugins(event.getBundle());
                break;
            }
        }
    }
}

