/*
 * Decompiled with CFR 0.152.
 */
package org.appops.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.appops.core.exception.CoreException;

public class ZipUtils {
    public void zip(File sourceFolder, File outputFile) {
        this.zip(new File[]{sourceFolder}, outputFile);
    }

    public void zip(File[] files, File outputFile) {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFile));){
            this.addEntries(files, out);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
    }

    private void addEntries(File[] files, ZipOutputStream out) {
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    this.addEntries(file.listFiles(), out);
                    continue;
                }
                ZipEntry e = new ZipEntry(file.getPath());
                out.putNextEntry(e);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

