/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.destination;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.logging.log4j.LoggingException;
import org.appops.logging.destination.DestinationLogger;
import org.appops.logging.logger.config.HandlerConfig;
import org.appops.logging.logger.config.LogFilter;
import org.appops.logging.logger.config.constant.FilterProperty;
import org.appops.logging.logger.config.constant.FilterReply;
import org.appops.logging.logger.config.constant.FilterType;
import org.appops.logging.logger.config.constant.HandlerAttribute;
import org.appops.logging.logger.config.constant.LoggerType;
import org.appops.logging.logger.formatter.JavaUtilLogFormatter;

public class JavaUtilLogger
extends DestinationLogger<Logger> {
    private Logger internalLogger;

    @Override
    public LoggerType type() {
        return LoggerType.JUL;
    }

    @Override
    public boolean log(org.appops.logging.meta.Level level, String message) {
        if (level == null) {
            level = org.appops.logging.meta.Level.ALL;
        }
        this.internalLogger().log(this.convertLevel(level.name()), message);
        return true;
    }

    @Override
    protected Logger internalLogger() {
        if (this.internalLogger == null) {
            this.internalLogger = LogManager.getLogManager().getLogger("");
        }
        return this.internalLogger;
    }

    @Override
    public void removeAllHandlers() {
        for (Handler deafaultHandler : this.internalLogger().getHandlers()) {
            this.internalLogger().removeHandler(deafaultHandler);
        }
    }

    @Override
    public void addHandlers(List<HandlerConfig> handlers) {
        if (handlers == null || handlers.isEmpty()) {
            throw new LoggingException("Please provide valid log handlers.");
        }
        for (HandlerConfig handler : handlers) {
            this.addHandler(handler);
        }
    }

    @Override
    public void addHandler(HandlerConfig handler) {
        if (handler == null) {
            throw new LoggingException("Log handler cannot be null.");
        }
        if (handler.enabled()) {
            switch (handler.name()) {
                case CONSOLE: {
                    this.addConsoleHandler(handler);
                    break;
                }
                case FILE: {
                    this.addFileAppender(handler);
                    break;
                }
                default: {
                    throw new LoggingException("Please provide valid log handler.");
                }
            }
        }
    }

    public void addConsoleHandler(HandlerConfig logHandler) {
        Map<HandlerAttribute, Object> config = logHandler.getConfig();
        ConsoleHandler handler = new ConsoleHandler();
        Level level = config.get((Object)HandlerAttribute.LEVEL) != null ? this.convertLevel(config.get((Object)HandlerAttribute.LEVEL).toString()) : Level.ALL;
        handler.setLevel(level);
        JavaUtilLogFormatter julFormatter = new JavaUtilLogFormatter();
        if (config.get((Object)HandlerAttribute.PATTERN) != null) {
            julFormatter.setFormat(this.formatPattern(config.get((Object)HandlerAttribute.PATTERN).toString()));
        }
        handler.setFormatter(julFormatter);
        this.addFilters(handler, logHandler.getFilters());
        this.internalLogger().setLevel(level);
        this.internalLogger().addHandler(handler);
    }

    private void addFileAppender(HandlerConfig handlerConfig) {
        Map<HandlerAttribute, Object> config = handlerConfig.getConfig();
        String filename = config.get((Object)HandlerAttribute.FILENAME) != null ? config.get((Object)HandlerAttribute.FILENAME).toString() : "JUL.log";
        Integer maxBackupIndex = config.get((Object)HandlerAttribute.MAX_BACKUP_INDEX) != null ? Integer.parseInt(config.get((Object)HandlerAttribute.MAX_BACKUP_INDEX).toString()) : 2;
        Level level = config.get((Object)HandlerAttribute.LEVEL) != null ? this.convertLevel(config.get((Object)HandlerAttribute.LEVEL).toString()) : Level.ALL;
        JavaUtilLogFormatter julFormatter = new JavaUtilLogFormatter();
        if (config.get((Object)HandlerAttribute.PATTERN) != null) {
            julFormatter.setFormat(this.formatPattern(config.get((Object)HandlerAttribute.PATTERN).toString()));
        }
        int fileSize = this.getFileSize(config.get((Object)HandlerAttribute.MAXSIZE));
        try {
            FileHandler fileHandler = new FileHandler(filename, fileSize, (int)maxBackupIndex, true);
            fileHandler.setLevel(level);
            fileHandler.setFormatter(julFormatter);
            this.addFilters(fileHandler, handlerConfig.getFilters());
            this.internalLogger().addHandler(fileHandler);
        }
        catch (Exception e) {
            System.out.println("Exception occurs while adding file handler::" + e);
        }
    }

    private int getFileSize(Object object) {
        int defaultSize = 0xA00000;
        try {
            if (object != null) {
                String sizeString = String.valueOf(object);
                String unit = sizeString.substring(sizeString.length() - 2, sizeString.length());
                int size = Integer.parseInt(sizeString.substring(0, sizeString.length() - 2));
                switch (unit.toUpperCase()) {
                    case "KB": {
                        return size * 1024;
                    }
                    case "MB": {
                        return size * 1024 * 1024;
                    }
                    case "GB": {
                        if (size < 2) {
                            return size * 1024 * 1024 * 1024;
                        }
                        return defaultSize;
                    }
                }
                return defaultSize;
            }
        }
        catch (Exception e) {
            System.out.println("Exception occured while converting file size it will use default size." + e);
        }
        return defaultSize;
    }

    private Level convertLevel(String level) {
        if (org.appops.logging.meta.Level.WARN.name().equals(level) || org.appops.logging.meta.Level.WARNING.name().equals(level)) {
            return Level.WARNING;
        }
        if (org.appops.logging.meta.Level.SEVERE.name().equals(level)) {
            return Level.SEVERE;
        }
        if (org.appops.logging.meta.Level.ALL.name().equals(level)) {
            return Level.ALL;
        }
        if (org.appops.logging.meta.Level.INFO.name().equals(level)) {
            return Level.INFO;
        }
        if (org.appops.logging.meta.Level.FINE.name().equals(level)) {
            return Level.FINE;
        }
        if (org.appops.logging.meta.Level.OFF.name().equals(level)) {
            return Level.OFF;
        }
        return Level.INFO;
    }

    @Override
    public String formatPattern(String pattern) {
        if ((pattern = pattern.trim().replaceAll(" +", " ")).contains("%d")) {
            if (!pattern.contains("%d{")) {
                pattern = pattern.replaceAll("%d", "%1\\$tF %1\\$tT");
            } else {
                pattern = pattern.replaceFirst("%d", "");
                pattern = pattern.replaceAll("\\{", "");
                pattern = pattern.replaceAll("\\}", "");
            }
        }
        pattern = pattern.replaceAll("%yyyy", "%1\\$tY");
        pattern = pattern.replaceAll("%MMMM", "%1\\$tB");
        pattern = pattern.replaceAll("%MMM", "%1\\$tb");
        pattern = pattern.replaceAll("%MM", "%1\\$tm");
        pattern = pattern.replaceAll("%dd", "%1\\$td");
        pattern = pattern.replaceAll("%HH", "%1\\$tk");
        pattern = pattern.replaceAll("%hh", "%1\\$tl");
        pattern = pattern.replaceAll("%mm", "%1\\$tM");
        pattern = pattern.replaceAll("%ss", "%1\\$tS");
        pattern = pattern.replaceAll("%logger", "%2\\$s");
        pattern = pattern.replaceAll("%level", "%4\\$s");
        pattern = pattern.replaceAll("%msg", "%5\\$s");
        return pattern;
    }

    private void addFilters(Handler handler, ArrayList<LogFilter> filters) {
        try {
            for (LogFilter filterConfig : filters) {
                if (!FilterType.RegEx.equals((Object)filterConfig.getName())) continue;
                handler.setFilter(this.addLogFilter(filterConfig));
            }
        }
        catch (Exception e) {
            throw new LoggingException("Exception Occured while adding filter to ::" + this.getClass().getCanonicalName() + e);
        }
    }

    private Filter addLogFilter(final LogFilter config) {
        return new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                if (config != null) {
                    if (FilterProperty.LOGGER_NAME.equals((Object)config.getApplyOn()) && record.getLoggerName().matches(config.getExpression())) {
                        return JavaUtilLogger.this.getvalue(config.getOnMatch());
                    }
                    if (FilterProperty.MESSAGE.equals((Object)config.getApplyOn()) && record.getMessage().toString().matches(config.getExpression())) {
                        return JavaUtilLogger.this.getvalue(config.getOnMatch());
                    }
                }
                return !JavaUtilLogger.this.getvalue(config.getOnMatch());
            }
        };
    }

    private boolean getvalue(FilterReply onMatch) {
        switch (onMatch) {
            case ACCEPT: {
                return true;
            }
            case DENY: {
                return false;
            }
        }
        return true;
    }
}

