/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.generator;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Set;
import org.appops.cache.event.EventSubscriber;
import org.appops.cache.event.Subscriber;
import org.appops.cache.slim.ServiceBus;
import org.appops.core.ClassPathAnalyser;
import org.appops.core.TypeScanner;
import org.appops.core.annotation.Job;
import org.appops.core.annotation.SubscriberListener;
import org.appops.core.job.JobMeta;
import org.appops.core.service.ExecutionMode;
import org.appops.core.service.ServiceRoute;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.core.service.meta.InterfaceMeta;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.service.job.JobExecService;
import org.appops.service.store.JobMetaRegistry;

public class ServiceMetaGenerator {
    private ClassPathAnalyser classPathAnalyser;
    private JobMetaRegistry jobMetaRegistry;
    private ServiceBus serviceBus;

    public ServiceMeta generateServiceMeta(String serviceName, String routeContext, String serviceUrl, Class<? extends Annotation> serviceAnnotation) {
        return this.generateServiceMeta(serviceName, routeContext, serviceUrl, serviceAnnotation, "");
    }

    public ServiceMeta generateServiceMeta(String serviceName, String routeContext, String serviceUrl, Class<? extends Annotation> serviceAnnotation, String refPackage) {
        ServiceMeta serviceMeta = new ServiceMeta(serviceName);
        serviceMeta.setRoute(new ServiceRoute(routeContext, serviceUrl));
        this.addServiceDetails(serviceAnnotation, serviceMeta, refPackage);
        this.addSubscriberDetails(serviceMeta, refPackage);
        return serviceMeta;
    }

    public ServiceMeta generateJesMeta(String serviceName, String routeContext, String serviceUrl, String refPackage, Class<? extends Annotation> serviceAnnotation) {
        ServiceMeta serviceMeta = new ServiceMeta(serviceName);
        serviceMeta.setExecutionMode(ExecutionMode.JOB);
        serviceMeta.setRoute(new ServiceRoute(routeContext, serviceUrl));
        this.addInterfaceMeta(JobExecService.class, serviceMeta);
        this.addJobDetails(serviceName, refPackage, serviceUrl);
        this.addServiceDetails(serviceAnnotation, serviceMeta, refPackage);
        this.addSubscriberDetails(serviceMeta, refPackage);
        return serviceMeta;
    }

    private void addJobDetails(String serviceName, String refPackage, String serviceUrl) {
        refPackage = refPackage == null ? "" : refPackage;
        Set<Class<?>> jobClasses = this.getClassPathAnalyser(refPackage).getAnnotatedTypes(Job.class);
        for (Class<?> jobClass : jobClasses) {
            Job annotatedJob = jobClass.getAnnotation(Job.class);
            if (annotatedJob == null) continue;
            JobMeta jobMeta = new JobMeta();
            jobMeta.setAffinity(annotatedJob.affinity());
            jobMeta.setQualifiedName(jobClass.getCanonicalName());
            jobMeta.setJobExecServiceAddress(serviceUrl + "/Op/" + serviceName + "/jes/execJob");
            this.getJobMetaRegistry().registerJobMeta(jobClass.getCanonicalName(), jobMeta);
        }
    }

    private void addServiceDetails(Class<? extends Annotation> serviceAnnotation, ServiceMeta serviceMeta, String refPackage) {
        refPackage = refPackage == null ? "" : refPackage;
        Set<Class<?>> serviceInterfaces = this.getClassPathAnalyser(refPackage).getAnnotatedTypes(serviceAnnotation);
        for (Class<?> serviceInterface : serviceInterfaces) {
            if (!serviceInterface.isInterface()) continue;
            this.addInterfaceMeta(serviceInterface, serviceMeta);
        }
    }

    private void addSubscriberDetails(ServiceMeta serviceMeta, String refPackage) {
        refPackage = refPackage == null ? "" : refPackage;
        Set<Class<?>> serviceAlternateInterfaces = this.getClassPathAnalyser(refPackage).getAnnotatedTypes(SubscriberListener.class);
        for (Class<?> serviceAlternateInterface : serviceAlternateInterfaces) {
            if (!serviceAlternateInterface.isInterface()) continue;
            this.registerSubscriberMeta(serviceAlternateInterface, serviceMeta);
        }
    }

    private void registerSubscriberMeta(Class<?> clazz, ServiceMeta serviceMeta) {
        for (Method method : this.getClassPathAnalyser().getAnnotatedMethods(clazz, ServiceOp.class)) {
            this.registerSubscriber(method, serviceMeta);
        }
    }

    private void registerSubscriber(Method method, ServiceMeta serviceMeta) {
        ServiceOp annotation = method.getAnnotation(ServiceOp.class);
        EventSubscriber baseSubscriber = new EventSubscriber();
        baseSubscriber.setServiceUrl(serviceMeta.getRoute().getServiceUrl());
        baseSubscriber.setServiceName(serviceMeta.getName());
        Parameter parameter = method.getParameters()[0];
        Subscriber subscriber = new Subscriber();
        subscriber.setMethodName(annotation.path());
        subscriber.setParameterName(parameter.getName());
        subscriber.setParameterType(parameter.getType().getCanonicalName());
        baseSubscriber.setSubscriber(subscriber);
        this.getServiceBus().register(baseSubscriber);
    }

    private void addInterfaceMeta(Class<?> clazz, ServiceMeta serviceMeta) {
        InterfaceMeta interfaceMeta = new InterfaceMeta();
        interfaceMeta.setName(clazz.getSimpleName());
        interfaceMeta.setQualifiedClassName(clazz.getCanonicalName());
        interfaceMeta.setParent(serviceMeta.lightweightCopy());
        serviceMeta.addInterface(interfaceMeta);
        for (Method method : this.getClassPathAnalyser().getAnnotatedMethods(clazz, ServiceOp.class)) {
            this.addOperation(method, interfaceMeta);
        }
    }

    private void addOperation(Method method, InterfaceMeta interfaceMeta) {
        ServiceOp annotation = method.getAnnotation(ServiceOp.class);
        ServiceOpMeta serviceOpMeta = new ServiceOpMeta();
        serviceOpMeta.setFriendly(annotation.friendly());
        serviceOpMeta.setMethod(annotation.method());
        serviceOpMeta.setPath(annotation.path());
        serviceOpMeta.setName(method.getName());
        serviceOpMeta.setResultTypeName(method.getReturnType().getCanonicalName());
        serviceOpMeta.setParent(interfaceMeta.lightweightCopy());
        this.addParameters(method.getParameters(), serviceOpMeta);
        interfaceMeta.addOperation(serviceOpMeta);
    }

    private void addParameters(Parameter[] parameters, ServiceOpMeta serviceOpMeta) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            org.appops.core.service.Parameter param = new org.appops.core.service.Parameter(i, parameter.getName());
            param.setTypeName(parameter.getType().getCanonicalName());
            serviceOpMeta.addParameter(param);
        }
    }

    public ClassPathAnalyser getClassPathAnalyser() {
        return this.getClassPathAnalyser("");
    }

    public ClassPathAnalyser getClassPathAnalyser(String refPackage) {
        if (this.classPathAnalyser == null) {
            this.classPathAnalyser = new ClassPathAnalyser();
            this.classPathAnalyser.setTypeScanner(new TypeScanner());
        }
        return this.classPathAnalyser;
    }

    public void setClassPathAnalyser(ClassPathAnalyser classPathAnalyser) {
        this.classPathAnalyser = classPathAnalyser;
    }

    public JobMetaRegistry getJobMetaRegistry() {
        return this.jobMetaRegistry;
    }

    @Inject
    public void setJobMetaRegistry(JobMetaRegistry jobMetaRegistry) {
        this.jobMetaRegistry = jobMetaRegistry;
    }

    public ServiceBus getServiceBus() {
        return this.serviceBus;
    }

    @Inject
    public void setServiceBus(ServiceBus subscriberRegistry) {
        this.serviceBus = subscriberRegistry;
    }
}

