/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.invocation;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.List;
import org.appops.core.TypeScanner;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.core.service.signature.ServiceOpSignatureBuilder;
import org.appops.service.exception.InvocationException;

public class MethodLocator {
    private TypeScanner scanner;
    private ServiceOpSignatureBuilder signatureBuilder;

    public Method findMethod(Class<?> parentClazz, ServiceOpMeta operation) {
        String opSignature = this.getSignatureBuilder().buildOpSignature(operation);
        List<Method> methods = this.getScanner().getAnnotatedMethods(parentClazz, ServiceOp.class);
        for (Method method : methods) {
            String path = method.getAnnotation(ServiceOp.class).path();
            if (path != null && !path.isEmpty() && path.equals(operation.getPath())) {
                return method;
            }
            String methodSignature = this.getSignatureBuilder().buildMethodSignature(parentClazz, method);
            if (methodSignature == null || !methodSignature.equals(opSignature)) continue;
            return method;
        }
        throw new InvocationException("Unable to locate method -> " + operation.getName() + ", in " + parentClazz.getCanonicalName());
    }

    public TypeScanner getScanner() {
        return this.scanner;
    }

    @Inject
    public void setScanner(TypeScanner scanner) {
        this.scanner = scanner;
    }

    public ServiceOpSignatureBuilder getSignatureBuilder() {
        return this.signatureBuilder;
    }

    @Inject
    public void setSignatureBuilder(ServiceOpSignatureBuilder signatureBuilder) {
        this.signatureBuilder = signatureBuilder;
    }
}

