/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.invocation;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.core.service.signature.ServiceOpSignatureBuilder;
import org.appops.service.exception.InvocationException;
import org.appops.service.lifecycle.CallStack;
import org.appops.slim.base.api.ServiceMetaManager;

public class OperationDecorator
implements MethodInterceptor {
    private Provider<CallStack> callStackProvider;
    private ServiceOpSignatureBuilder signatureBuilder;
    private Provider<ServiceMetaManager> serviceMetaManager;

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        Method method = mi.getMethod();
        ServiceOpMeta operation = this.findOperation(method);
        this.getCallStack().addOperation(operation);
        Object res = null;
        try {
            res = mi.proceed();
        }
        catch (Exception e) {
            this.getCallStack().failedWithException(e);
            throw new InvocationException("Error while executing jobs for operation ::" + operation.getName() + ":: " + e.getMessage());
        }
        finally {
            this.getCallStack().callFinished();
        }
        return res;
    }

    private ServiceOpMeta findOperation(Method method) {
        if (method.isAnnotationPresent(ServiceOp.class)) {
            String signature = this.getSignatureBuilder().buildMethodSignature(method.getClass(), method);
            return this.getServiceStore().getOpMeta(signature);
        }
        throw new InvocationException("Operation not found for ->" + method.getName());
    }

    public CallStack getCallStack() {
        return this.callStackProvider.get();
    }

    @Inject
    public void setCallStackProvider(Provider<CallStack> callStackProvider) {
        this.callStackProvider = callStackProvider;
    }

    @Inject
    public void setServiceStore(Provider<ServiceMetaManager> serviceMetaManager) {
        this.serviceMetaManager = serviceMetaManager;
    }

    public ServiceOpSignatureBuilder getSignatureBuilder() {
        return this.signatureBuilder;
    }

    @Inject
    public void setSignatureBuilder(ServiceOpSignatureBuilder signatureBuilder) {
        this.signatureBuilder = signatureBuilder;
    }

    public ServiceMetaManager getServiceStore() {
        return this.serviceMetaManager.get();
    }
}

