/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.restexpress.ContentType;
import org.restexpress.exception.BadRequestException;
import org.restexpress.route.Route;
import org.restexpress.route.RouteResolver;
import org.restexpress.serialization.SerializationProvider;
import org.restexpress.serialization.SerializationSettings;
import org.restexpress.url.QueryStringParser;

public class Request {
    private static AtomicLong nextCorrelationId = new AtomicLong(0L);
    private FullHttpRequest httpRequest;
    private HttpVersion httpVersion;
    private InetSocketAddress remoteAddress;
    private RouteResolver routeResolver;
    private SerializationProvider serializationProvider;
    private HttpMethod effectiveHttpMethod;
    private Route resolvedRoute;
    private String correlationId;
    private Map<String, Object> attachments;
    private Map<String, String> queryStringMap;
    private SerializationSettings serializationSettings;

    public Request(FullHttpRequest request, RouteResolver routeResolver) {
        this(request, routeResolver, null);
    }

    public Request(FullHttpRequest request, RouteResolver routeResolver, SerializationProvider serializationProvider) {
        this.httpRequest = request;
        this.httpVersion = request.getProtocolVersion();
        this.effectiveHttpMethod = request.getMethod();
        this.routeResolver = routeResolver;
        this.serializationProvider = serializationProvider;
        this.createCorrelationId();
        this.queryStringMap = new HashMap<String, String>();
        this.parseQueryString(request);
        this.determineEffectiveHttpMethod(request);
    }

    public Request(InetSocketAddress socketAddress, FullHttpRequest request, RouteResolver routes, SerializationProvider serializationProvider) {
        this(request, routes, serializationProvider);
        this.remoteAddress = socketAddress;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public HttpMethod getHttpMethod() {
        return this.httpRequest.getMethod();
    }

    public HttpMethod getEffectiveHttpMethod() {
        return this.effectiveHttpMethod;
    }

    public boolean isMethodGet() {
        return this.getEffectiveHttpMethod().equals(HttpMethod.GET);
    }

    public boolean isMethodDelete() {
        return this.getEffectiveHttpMethod().equals(HttpMethod.DELETE);
    }

    public boolean isMethodPost() {
        return this.getEffectiveHttpMethod().equals(HttpMethod.POST);
    }

    public boolean isMethodPut() {
        return this.getEffectiveHttpMethod().equals(HttpMethod.PUT);
    }

    public ByteBuf getBody() {
        return this.httpRequest.content();
    }

    public String getMediaType() {
        return this.getSerializationSettings().getMediaType();
    }

    public <T> T getBodyAs(Class<T> type) {
        return this.getSerializationSettings().deserialize(this, type);
    }

    public SerializationSettings getSerializationSettings() {
        if (this.serializationSettings == null) {
            this.serializationSettings = this.serializationProvider.resolveRequest(this);
        }
        return this.serializationSettings;
    }

    public <T> T getBodyAs(Class<T> type, String message) {
        T instance = this.getBodyAs(type);
        if (instance == null) {
            throw new BadRequestException(message);
        }
        return instance;
    }

    public InputStream getBodyAsStream() {
        return new ByteBufInputStream(this.getBody());
    }

    public ByteBuffer getBodyAsByteBuffer() {
        return this.getBody().nioBuffer();
    }

    public byte[] getBodyAsBytes() {
        return this.getBody().hasArray() ? this.getBody().array() : null;
    }

    public Map<String, List<String>> getBodyFromUrlFormEncoded() {
        return this.getBodyFromUrlFormEncoded(true);
    }

    public Map<String, List<String>> getBodyFromUrlFormEncoded(boolean shouldDecode) {
        if (shouldDecode) {
            QueryStringDecoder qsd = new QueryStringDecoder(this.getBody().toString(ContentType.CHARSET), ContentType.CHARSET, false);
            return qsd.parameters();
        }
        QueryStringParser qsp = new QueryStringParser(this.getBody().toString(ContentType.CHARSET), false);
        return qsp.getParameters();
    }

    public void setBody(ByteBuf body) {
        this.httpRequest.content().setBytes(0, body);
    }

    public void clearHeaders() {
        this.httpRequest.headers().clear();
    }

    public String getHeader(String name) {
        return this.httpRequest.headers().get(name);
    }

    public List<String> getHeaders(String name) {
        return this.httpRequest.headers().getAll(name);
    }

    public String getHeader(String name, String message) {
        String value = this.getHeader(name);
        if (value == null) {
            throw new BadRequestException(message);
        }
        return value;
    }

    public Set<String> getHeaderNames() {
        return this.httpRequest.headers().names();
    }

    public void addHeader(String name, String value) {
        this.httpRequest.headers().add(name, (Object)value);
    }

    public void addAllHeaders(Collection<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> entry : headers) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public Route getResolvedRoute() {
        return this.resolvedRoute;
    }

    public void setResolvedRoute(Route route) {
        this.resolvedRoute = route;
    }

    public String getPath() {
        return this.httpRequest.getUri();
    }

    public String getBaseUrl() {
        return this.getProtocol() + "://" + this.getHost();
    }

    public String getUrl() {
        return this.getBaseUrl() + this.getPath();
    }

    public String getNamedUrl(String resourceName) {
        return this.getNamedUrl(this.getEffectiveHttpMethod(), resourceName);
    }

    public String getNamedUrl(HttpMethod method, String resourceName) {
        Route route = this.routeResolver.getNamedRoute(resourceName, method);
        if (route != null) {
            return route.getFullPattern();
        }
        return null;
    }

    public String getNamedPath(HttpMethod method, String resourceName) {
        Route route = this.routeResolver.getNamedRoute(resourceName, method);
        if (route != null) {
            return route.getPattern();
        }
        return null;
    }

    public Map<String, String> getQueryStringMap() {
        return this.queryStringMap;
    }

    public boolean isKeepAlive() {
        return HttpHeaders.isKeepAlive(this.httpRequest);
    }

    public boolean isChunked() {
        for (String header : this.httpRequest.headers().getAll("Transfer-Encoding")) {
            if (!"chunked".equalsIgnoreCase(header)) continue;
            return true;
        }
        return false;
    }

    public String getFormat() {
        return this.getHeader("format");
    }

    public String getHost() {
        return HttpHeaders.getHost(this.httpRequest);
    }

    public String getProtocol() {
        return this.httpRequest.getProtocolVersion().protocolName().toLowerCase();
    }

    public boolean isFormatEqual(String format) {
        return this.isHeaderEqual("format", format);
    }

    public boolean isHeaderEqual(String name, String value) {
        String header = this.getHeader(name);
        if (header == null || header.trim().length() == 0 || value == null || value.trim().length() == 0) {
            return false;
        }
        return header.trim().equalsIgnoreCase(value.trim());
    }

    public boolean isFlagged(String flag) {
        return this.resolvedRoute.isFlagged(flag);
    }

    public Object getParameter(String name) {
        return this.resolvedRoute.getParameter(name);
    }

    public Object getAttachment(String name) {
        if (this.attachments != null) {
            return this.attachments.get(name);
        }
        return null;
    }

    public boolean hasAttachment(String name) {
        return this.getAttachment(name) != null;
    }

    public void putAttachment(String name, Object attachment) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Object>();
        }
        this.attachments.put(name, attachment);
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public boolean isHttpVersion1_0() {
        return this.httpVersion.majorVersion() == 1 && this.httpVersion.minorVersion() == 0;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    private void parseQueryString(HttpRequest request) {
        if (!request.getUri().contains("?")) {
            return;
        }
        Map<String, List<String>> parameters = new QueryStringParser(request.getUri(), true).getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        this.queryStringMap = new HashMap<String, String>(parameters.size());
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            this.queryStringMap.put(entry.getKey(), entry.getValue().get(0));
            for (String value : entry.getValue()) {
                try {
                    request.headers().add(entry.getKey(), (Object)URLDecoder.decode(value, "UTF-8"));
                }
                catch (Exception e) {
                    request.headers().add(entry.getKey(), (Object)value);
                }
            }
        }
    }

    private void determineEffectiveHttpMethod(HttpRequest request) {
        if (!HttpMethod.POST.equals(request.getMethod())) {
            return;
        }
        String methodString = request.headers().get("_method");
        if ("PUT".equalsIgnoreCase(methodString) || "DELETE".equalsIgnoreCase(methodString)) {
            this.effectiveHttpMethod = HttpMethod.valueOf(methodString.toUpperCase());
        }
    }

    private void createCorrelationId() {
        this.correlationId = String.valueOf(nextCorrelationId.incrementAndGet());
    }
}

