/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.domain;

import org.restexpress.Response;
import org.restexpress.exception.ExceptionUtils;
import org.restexpress.exception.ServiceException;

public class JsendResultWrapper {
    private static final String STATUS_SUCCESS = "success";
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_FAIL = "fail";
    private int code;
    private String status;
    private String message;
    private Object data;

    public JsendResultWrapper(int httpResponseCode, String status, String errorMessage, Object data) {
        this.code = httpResponseCode;
        this.status = status;
        this.message = errorMessage;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStatus() {
        return this.status;
    }

    public Object getData() {
        return this.data;
    }

    public static JsendResultWrapper fromResponse(Response response) {
        if (response.hasException()) {
            String causeName;
            Throwable exception = response.getException();
            Throwable rootCause = ExceptionUtils.findRootCause(exception);
            String message = rootCause != null ? rootCause.getMessage() : exception.getMessage();
            String string = causeName = rootCause != null ? rootCause.getClass().getSimpleName() : exception.getClass().getSimpleName();
            if (ServiceException.isAssignableFrom(exception)) {
                return new JsendResultWrapper(response.getResponseStatus().code(), STATUS_ERROR, message, causeName);
            }
            return new JsendResultWrapper(response.getResponseStatus().code(), STATUS_FAIL, message, causeName);
        }
        int code = response.getResponseStatus().code();
        if (code >= 400 && code < 500) {
            return new JsendResultWrapper(response.getResponseStatus().code(), STATUS_ERROR, null, response.getBody());
        }
        if (code >= 500 && code < 600) {
            return new JsendResultWrapper(response.getResponseStatus().code(), STATUS_FAIL, null, response.getBody());
        }
        return new JsendResultWrapper(response.getResponseStatus().code(), STATUS_SUCCESS, null, response.getBody());
    }
}

