/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.preprocessor;

import javax.xml.bind.DatatypeConverter;
import org.restexpress.ContentType;
import org.restexpress.Request;
import org.restexpress.exception.UnauthorizedException;
import org.restexpress.pipeline.Preprocessor;
import org.restexpress.route.Route;

public class HttpBasicAuthenticationPreprocessor
implements Preprocessor {
    public static final String X_AUTHENTICATED_USER = "X-AuthenticatedUser";
    public static final String X_AUTHENTICATED_PASSWORD = "X-AuthenticatedPassword";
    private String realm;
    private String[] skipFlags;

    public HttpBasicAuthenticationPreprocessor(String realm) {
        this(realm, null);
    }

    public HttpBasicAuthenticationPreprocessor(String realm, String ... flags) {
        this.realm = realm;
        if (flags != null && flags.length > 0) {
            this.skipFlags = (String[])flags.clone();
        }
    }

    @Override
    public void process(Request request) {
        String[] pieces;
        byte[] bytes;
        String credentials;
        String[] parts;
        Route route = request.getResolvedRoute();
        if (route != null && (route.isFlagged("not.secured") || route.isFlagged("no.authentication") || route.containsAnyFlags(this.skipFlags))) {
            return;
        }
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Basic ")) {
            this.throwUnauthorizedException();
        }
        if ((parts = (credentials = new String(bytes = DatatypeConverter.parseBase64Binary((pieces = authorization.split(" "))[1]), ContentType.CHARSET)).split(":")).length < 2) {
            this.throwUnauthorizedException();
        }
        request.addHeader(X_AUTHENTICATED_USER, parts[0]);
        request.addHeader(X_AUTHENTICATED_PASSWORD, parts[1]);
        request.putAttachment(X_AUTHENTICATED_USER, parts[0]);
        request.putAttachment(X_AUTHENTICATED_PASSWORD, parts[1]);
    }

    private void throwUnauthorizedException() {
        UnauthorizedException e = new UnauthorizedException("Authentication required");
        e.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
        throw e;
    }
}

