/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restexpress.Request;
import org.restexpress.common.query.QueryRange;
import org.restexpress.exception.BadRequestException;

public abstract class QueryRanges {
    private static final String LIMIT_HEADER_NAME = "limit";
    private static final String OFFSET_HEADER_NAME = "offset";
    private static final String RANGE_HEADER_NAME = "Range";
    private static final String ITEMS_HEADER_REGEX = "items=(\\d+)-(\\d+)";
    private static final Pattern ITEMS_HEADER_PATTERN = Pattern.compile("items=(\\d+)-(\\d+)");

    public static QueryRange parseFrom(Request request, int limit) {
        QueryRange range = new QueryRange();
        range.setOffset(0L);
        range.setLimit(limit);
        QueryRanges.parseInto(request, range);
        return range;
    }

    public static QueryRange parseFrom(Request request) {
        QueryRange range = new QueryRange();
        QueryRanges.parseInto(request, range);
        return range;
    }

    private static void parseInto(Request request, QueryRange range) {
        String offset;
        String limit = request.getHeader(LIMIT_HEADER_NAME);
        if (!QueryRanges.parseLimitAndOffset(limit, offset = request.getHeader(OFFSET_HEADER_NAME), range)) {
            QueryRanges.parseRangeHeader(request, range);
        }
    }

    private static boolean parseLimitAndOffset(String limit, String offset, QueryRange range) {
        boolean hasLimit = false;
        boolean hasOffset = false;
        if (limit != null && !limit.trim().isEmpty()) {
            hasLimit = true;
            range.setLimit(Integer.parseInt(limit));
        }
        if (offset != null && !offset.trim().isEmpty()) {
            hasOffset = true;
            range.setOffset(Long.parseLong(offset));
        } else if (hasLimit) {
            range.setOffset(0L);
        }
        if (hasLimit || hasOffset) {
            if (!range.isValid()) {
                throw new BadRequestException("Invalid 'limit' and 'offset' parameters: limit=" + limit + " offset=" + offset);
            }
            return true;
        }
        return false;
    }

    private static void parseRangeHeader(Request request, QueryRange range) {
        String rangeHeader = request.getHeader(RANGE_HEADER_NAME);
        if (rangeHeader != null && !rangeHeader.trim().isEmpty()) {
            Matcher matcher = ITEMS_HEADER_PATTERN.matcher(rangeHeader);
            if (!matcher.matches()) {
                throw new BadRequestException("Unparseable 'Range' header.  Expecting items=[start]-[end] was: " + rangeHeader);
            }
            try {
                range.setOffset(Long.parseLong(matcher.group(1)));
                range.setLimitViaEnd(Long.parseLong(matcher.group(2)));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid 'Range' header.  Expecting 'items=[start]-[end]'  was: " + rangeHeader);
            }
            if (!range.isValid()) {
                throw new BadRequestException("Invalid 'Range' header.  Expecting 'items=[start]-[end]'  was: " + rangeHeader);
            }
        }
    }
}

