/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.response;

import java.nio.ByteBuffer;
import java.util.List;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.contenttype.MediaRange;
import org.restexpress.response.ResponseWrapper;
import org.restexpress.serialization.SerializationProcessor;

public class ResponseProcessor {
    private SerializationProcessor serializer;
    private ResponseWrapper wrapper;

    public ResponseProcessor(SerializationProcessor serializer, ResponseWrapper wrapper) {
        this.serializer = serializer;
        this.wrapper = wrapper;
    }

    public SerializationProcessor getSerializer() {
        return this.serializer;
    }

    public ResponseWrapper getWrapper() {
        return this.wrapper;
    }

    public List<MediaRange> getSupportedMediaRanges() {
        return this.serializer.getSupportedMediaRanges();
    }

    public <T> T deserialize(Request request, Class<T> type) {
        return this.serializer.deserialize(request.getBody(), type);
    }

    public ByteBuffer serialize(Response response) {
        Object wrapped = this.wrapper.wrap(response);
        if (wrapped != null) {
            return this.serializer.serialize(wrapped);
        }
        return null;
    }
}

