/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.serialization.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.restexpress.ContentType;
import org.restexpress.serialization.DeserializationException;
import org.restexpress.serialization.SerializationException;
import org.restexpress.serialization.json.JacksonEncodingStringSerializer;
import org.restexpress.serialization.json.JacksonTimepointDeserializer;
import org.restexpress.serialization.json.JacksonTimepointSerializer;
import org.restexpress.serialization.json.JsonSerializationProcessor;

public class JacksonJsonProcessor
extends JsonSerializationProcessor {
    private static final byte[] EMPTY_STRING_BYTES = "".getBytes(ContentType.CHARSET);
    private ObjectMapper mapper;
    private boolean shouldOutboundEncode;

    public JacksonJsonProcessor() {
        this(true);
    }

    public JacksonJsonProcessor(boolean shouldOutboundEncode) {
        this("json", shouldOutboundEncode);
    }

    public JacksonJsonProcessor(String format) {
        this(format, true);
    }

    public JacksonJsonProcessor(String format, boolean shouldOutboundEncode) {
        super(format);
        this.shouldOutboundEncode = shouldOutboundEncode;
        SimpleModule module = new SimpleModule();
        this.initializeModule(module);
    }

    public JacksonJsonProcessor(SimpleModule module) {
        this.initialize(module);
    }

    public JacksonJsonProcessor(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    private void initialize(SimpleModule module) {
        this.mapper = new ObjectMapper();
        this.mapper.registerModule(module);
        this.initializeMapper(this.mapper);
    }

    protected void initializeModule(SimpleModule module) {
        module.addSerializer(Date.class, new JacksonTimepointSerializer()).addDeserializer(Date.class, new JacksonTimepointDeserializer());
        if (this.shouldOutboundEncode) {
            module.addSerializer(String.class, new JacksonEncodingStringSerializer());
        }
        this.initialize(module);
    }

    protected void initializeMapper(ObjectMapper mapper) {
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE).setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"));
    }

    @Override
    public <T> T deserialize(String string, Class<T> type) {
        try {
            return string == null || string.trim().isEmpty() ? null : (T)this.mapper.readValue(string, type);
        }
        catch (JsonProcessingException e) {
            throw new DeserializationException(e);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public <T> T deserialize(ByteBuf buffer, Class<T> type) {
        try {
            return buffer == null || buffer.readableBytes() == 0 ? null : (T)this.mapper.readValue((Reader)new InputStreamReader((InputStream)new ByteBufInputStream(buffer), ContentType.CHARSET), type);
        }
        catch (JsonProcessingException e) {
            throw new DeserializationException(e);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public ByteBuffer serialize(Object object) {
        try {
            if (object == null) {
                return ByteBuffer.wrap(EMPTY_STRING_BYTES);
            }
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            this.mapper.writeValue(b, object);
            return ByteBuffer.wrap(b.toByteArray());
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }
}

