/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.restexpress.common.exception.ConfigurationException;

public abstract class Environment {
    private static final String ENVIRONMENT_DIR = "config/";
    private static final String PROPERTIES_FILENAME = "/environment.properties";
    private static final String DEFAULT_ENVIRONMENT = "dev";

    public static <T extends Environment> T load(String[] args, Class<T> type) throws FileNotFoundException, IOException {
        if (args.length > 0) {
            return Environment.from(args[0], type);
        }
        return Environment.fromDefault(type);
    }

    public static <T extends Environment> T fromDefault(Class<T> type) throws FileNotFoundException, IOException {
        return Environment.from(DEFAULT_ENVIRONMENT, type);
    }

    public static <T extends Environment> T from(String environmentName, Class<T> type) throws FileNotFoundException, IOException {
        Environment instance = (Environment)Environment.newEnvironment(type);
        if (environmentName != null) {
            instance.load(ENVIRONMENT_DIR + environmentName + PROPERTIES_FILENAME);
        }
        return (T)instance;
    }

    protected void load(String filename) throws ConfigurationException, FileNotFoundException, IOException {
        Properties p = this.readProperties(filename);
        this.fillValues(p);
    }

    protected abstract void fillValues(Properties var1) throws ConfigurationException;

    protected Properties readProperties(String environmentFile) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        boolean wasLoadedFromClasspath = this.loadFromClasspath(environmentFile, properties);
        FileInputStream fis = null;
        try {
            File envFile = new File(environmentFile);
            fis = new FileInputStream(envFile);
            properties.load(fis);
            Properties properties2 = properties;
            return properties2;
        }
        catch (FileNotFoundException e) {
            if (!wasLoadedFromClasspath) {
                throw e;
            }
            Properties properties3 = properties;
            return properties3;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFromClasspath(String environmentFile, Properties properties) throws IOException {
        String modified = environmentFile.startsWith("/") ? environmentFile : "/" + environmentFile;
        InputStream cpis = this.getClass().getResourceAsStream(modified);
        try {
            if (cpis != null) {
                properties.load(cpis);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (cpis != null) {
                    cpis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static <T> T newEnvironment(Class<T> type) {
        T instance = null;
        try {
            instance = type.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return instance;
    }
}

