/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.injection;

import com.google.common.util.concurrent.ServiceManager;
import org.appops.core.annotation.SlimModule;
import org.appops.service.job.TokenRouter;
import org.appops.service.store.JobMetaRegistry;
import org.appops.slim.base.api.ServiceMetaManager;
import org.appops.slim.base.core.ServiceStore;
import org.appops.slim.base.injection.ServiceSlimModule;

/**
 * <p>
 * ServiceStoreSlimModule class.
 * </p>
 *
 * @author deba
 * @version $Id: $Id
 */
@ServiceStore
@SlimModule(serviceName = ServiceStore.class)
public class ServiceStoreSlimModule extends ServiceSlimModule {

  /** {@inheritDoc} */
  @Override
  public void configureModule() {
    bindServiceApi(ServiceManager.class);
    bindServiceApi(ServiceMetaManager.class);
    bindServiceApi(JobMetaRegistry.class);
    bindServiceApi(TokenRouter.class);
  }

}
