/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.asm;

import com.google.inject.internal.asm.$AnnotationVisitor;
import com.google.inject.internal.asm.$AnnotationWriter;
import com.google.inject.internal.asm.$Attribute;
import com.google.inject.internal.asm.$ByteVector;
import com.google.inject.internal.asm.$RecordComponentVisitor;
import com.google.inject.internal.asm.$SymbolTable;
import com.google.inject.internal.asm.$TypePath;

final class $RecordComponentWriter
extends $RecordComponentVisitor {
    private final $SymbolTable symbolTable;
    private final int nameIndex;
    private final int descriptorIndex;
    private int signatureIndex;
    private $AnnotationWriter lastRuntimeVisibleAnnotation;
    private $AnnotationWriter lastRuntimeInvisibleAnnotation;
    private $AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private $AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private $Attribute firstAttribute;

    $RecordComponentWriter($SymbolTable symbolTable, String name, String descriptor, String signature) {
        super(589824);
        this.symbolTable = symbolTable;
        this.nameIndex = symbolTable.addConstantUtf8(name);
        this.descriptorIndex = symbolTable.addConstantUtf8(descriptor);
        if (signature != null) {
            this.signatureIndex = symbolTable.addConstantUtf8(signature);
        }
    }

    public $AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (visible) {
            this.lastRuntimeVisibleAnnotation = $AnnotationWriter.create(($SymbolTable)this.symbolTable, (String)descriptor, ($AnnotationWriter)this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = $AnnotationWriter.create(($SymbolTable)this.symbolTable, (String)descriptor, ($AnnotationWriter)this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public $AnnotationVisitor visitTypeAnnotation(int typeRef, $TypePath typePath, String descriptor, boolean visible) {
        if (visible) {
            this.lastRuntimeVisibleTypeAnnotation = $AnnotationWriter.create(($SymbolTable)this.symbolTable, (int)typeRef, ($TypePath)typePath, (String)descriptor, ($AnnotationWriter)this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = $AnnotationWriter.create(($SymbolTable)this.symbolTable, (int)typeRef, ($TypePath)typePath, (String)descriptor, ($AnnotationWriter)this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public void visitAttribute($Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    public void visitEnd() {
    }

    int computeRecordComponentInfoSize() {
        int size = 6;
        size += $Attribute.computeAttributesSize(($SymbolTable)this.symbolTable, (int)0, (int)this.signatureIndex);
        size += $AnnotationWriter.computeAnnotationsSize(($AnnotationWriter)this.lastRuntimeVisibleAnnotation, ($AnnotationWriter)this.lastRuntimeInvisibleAnnotation, ($AnnotationWriter)this.lastRuntimeVisibleTypeAnnotation, ($AnnotationWriter)this.lastRuntimeInvisibleTypeAnnotation);
        if (this.firstAttribute != null) {
            size += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        return size;
    }

    void putRecordComponentInfo($ByteVector output) {
        output.putShort(this.nameIndex).putShort(this.descriptorIndex);
        int attributesCount = 0;
        if (this.signatureIndex != 0) {
            ++attributesCount;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++attributesCount;
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++attributesCount;
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++attributesCount;
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++attributesCount;
        }
        if (this.firstAttribute != null) {
            attributesCount += this.firstAttribute.getAttributeCount();
        }
        output.putShort(attributesCount);
        $Attribute.putAttributes(($SymbolTable)this.symbolTable, (int)0, (int)this.signatureIndex, ($ByteVector)output);
        $AnnotationWriter.putAnnotations(($SymbolTable)this.symbolTable, ($AnnotationWriter)this.lastRuntimeVisibleAnnotation, ($AnnotationWriter)this.lastRuntimeInvisibleAnnotation, ($AnnotationWriter)this.lastRuntimeVisibleTypeAnnotation, ($AnnotationWriter)this.lastRuntimeInvisibleTypeAnnotation, ($ByteVector)output);
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, output);
        }
    }

    final void collectAttributePrototypes($Attribute.Set attributePrototypes) {
        attributePrototypes.addAttributes(this.firstAttribute);
    }
}

