/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Vector;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.security.Escape;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class JspUtil {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags/";
    private static final String META_INF_TAGS = "/META-INF/tags/";
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String[] javaKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    public static final int CHUNKSIZE = 1024;

    public static String getExprInXml(String expression) {
        int length = expression.length();
        String returnString = expression.startsWith(OPEN_EXPR) && expression.endsWith(CLOSE_EXPR) ? expression.substring(1, length - 1) : expression;
        return Escape.xml(returnString);
    }

    public static void checkScope(String scope, Node n, ErrorDispatcher err) throws JasperException {
        if (!(scope == null || scope.equals("page") || scope.equals("request") || scope.equals("session") || scope.equals("application"))) {
            err.jspError(n, "jsp.error.invalid.scope", scope);
        }
    }

    public static void checkAttributes(String typeOfTag, Node n, ValidAttribute[] validAttributes, ErrorDispatcher err) throws JasperException {
        int attrLeftLength;
        int i;
        Attributes attrs = n.getAttributes();
        Mark start = n.getStart();
        boolean valid = true;
        int tempLength = attrs == null ? 0 : attrs.getLength();
        Vector<String> temp = new Vector<String>(tempLength, 1);
        for (int i2 = 0; i2 < tempLength; ++i2) {
            String qName = attrs.getQName(i2);
            if (qName.equals("xmlns") || qName.startsWith("xmlns:")) continue;
            temp.addElement(qName);
        }
        Node.Nodes tagBody = n.getBody();
        if (tagBody != null) {
            Node node;
            int numSubElements = tagBody.size();
            for (i = 0; i < numSubElements && (node = tagBody.getNode(i)) instanceof Node.NamedAttribute; ++i) {
                String attrName = node.getAttributeValue("name");
                temp.addElement(attrName);
                if (n.getAttributeValue(attrName) == null) continue;
                err.jspError(n, "jsp.error.duplicate.name.jspattribute", attrName);
            }
        }
        String missingAttribute = null;
        for (i = 0; i < validAttributes.length; ++i) {
            if (!validAttributes[i].mandatory) continue;
            int attrPos = temp.indexOf(validAttributes[i].name);
            if (attrPos != -1) {
                temp.remove(attrPos);
                valid = true;
                continue;
            }
            valid = false;
            missingAttribute = validAttributes[i].name;
            break;
        }
        if (!valid) {
            err.jspError(start, "jsp.error.mandatory.attribute", typeOfTag, missingAttribute);
        }
        if ((attrLeftLength = temp.size()) == 0) {
            return;
        }
        String attribute = null;
        for (int j = 0; j < attrLeftLength; ++j) {
            valid = false;
            attribute = (String)temp.elementAt(j);
            for (int i3 = 0; i3 < validAttributes.length; ++i3) {
                if (!attribute.equals(validAttributes[i3].name)) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            err.jspError(start, "jsp.error.invalid.attribute", typeOfTag, attribute);
        }
    }

    @Deprecated
    public static String escapeXml(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean booleanValue(String s2) {
        boolean b = false;
        if (s2 != null) {
            b = s2.equalsIgnoreCase("yes") ? true : Boolean.parseBoolean(s2);
        }
        return b;
    }

    public static Class<?> toClass(String type, ClassLoader loader) throws ClassNotFoundException {
        Class<Object> c = null;
        int i0 = type.indexOf(91);
        int dims = 0;
        if (i0 > 0) {
            for (int i = 0; i < type.length(); ++i) {
                if (type.charAt(i) != '[') continue;
                ++dims;
            }
            type = type.substring(0, i0);
        }
        if ("boolean".equals(type)) {
            c = Boolean.TYPE;
        } else if ("char".equals(type)) {
            c = Character.TYPE;
        } else if ("byte".equals(type)) {
            c = Byte.TYPE;
        } else if ("short".equals(type)) {
            c = Short.TYPE;
        } else if ("int".equals(type)) {
            c = Integer.TYPE;
        } else if ("long".equals(type)) {
            c = Long.TYPE;
        } else if ("float".equals(type)) {
            c = Float.TYPE;
        } else if ("double".equals(type)) {
            c = Double.TYPE;
        } else if ("void".equals(type)) {
            c = Void.TYPE;
        } else if (type.indexOf(91) < 0) {
            c = loader.loadClass(type);
        }
        if (dims == 0) {
            return c;
        }
        if (dims == 1) {
            return Array.newInstance(c, 1).getClass();
        }
        return Array.newInstance(c, new int[dims]).getClass();
    }

    public static String interpreterCall(boolean isTagFile, String expression, Class<?> expectedType, String fnmapvar) {
        String returnType;
        String jspCtxt = null;
        jspCtxt = isTagFile ? "this.getJspContext()" : "_jspx_page_context";
        String targetType = returnType = expectedType.getCanonicalName();
        String primitiveConverterMethod = null;
        if (expectedType.isPrimitive()) {
            if (expectedType.equals(Boolean.TYPE)) {
                returnType = Boolean.class.getName();
                primitiveConverterMethod = "booleanValue";
            } else if (expectedType.equals(Byte.TYPE)) {
                returnType = Byte.class.getName();
                primitiveConverterMethod = "byteValue";
            } else if (expectedType.equals(Character.TYPE)) {
                returnType = Character.class.getName();
                primitiveConverterMethod = "charValue";
            } else if (expectedType.equals(Short.TYPE)) {
                returnType = Short.class.getName();
                primitiveConverterMethod = "shortValue";
            } else if (expectedType.equals(Integer.TYPE)) {
                returnType = Integer.class.getName();
                primitiveConverterMethod = "intValue";
            } else if (expectedType.equals(Long.TYPE)) {
                returnType = Long.class.getName();
                primitiveConverterMethod = "longValue";
            } else if (expectedType.equals(Float.TYPE)) {
                returnType = Float.class.getName();
                primitiveConverterMethod = "floatValue";
            } else if (expectedType.equals(Double.TYPE)) {
                returnType = Double.class.getName();
                primitiveConverterMethod = "doubleValue";
            }
        }
        targetType = JspUtil.toJavaSourceType(targetType);
        StringBuilder call = new StringBuilder("(" + returnType + ") " + "org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate" + "(" + Generator.quote(expression) + ", " + targetType + ".class, " + "(javax.servlet.jsp.PageContext)" + jspCtxt + ", " + fnmapvar + ")");
        if (primitiveConverterMethod != null) {
            call.insert(0, "(");
            call.append(")." + primitiveConverterMethod + "()");
        }
        return call.toString();
    }

    public static String coerceToPrimitiveBoolean(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToBoolean(" + s2 + ")";
        }
        if (s2 == null || s2.length() == 0) {
            return "false";
        }
        return Boolean.valueOf(s2).toString();
    }

    public static String coerceToBoolean(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(java.lang.Boolean) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s2 + ", java.lang.Boolean.class)";
        }
        if (s2 == null || s2.length() == 0) {
            return "new java.lang.Boolean(false)";
        }
        return "new java.lang.Boolean(" + Boolean.valueOf(s2).toString() + ")";
    }

    public static String coerceToPrimitiveByte(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToByte(" + s2 + ")";
        }
        if (s2 == null || s2.length() == 0) {
            return "(byte) 0";
        }
        return "((byte)" + Byte.valueOf(s2).toString() + ")";
    }

    public static String coerceToByte(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(java.lang.Byte) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s2 + ", java.lang.Byte.class)";
        }
        if (s2 == null || s2.length() == 0) {
            return "new java.lang.Byte((byte) 0)";
        }
        return "new java.lang.Byte((byte)" + Byte.valueOf(s2).toString() + ")";
    }

    public static String coerceToChar(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToChar(" + s2 + ")";
        }
        if (s2 == null || s2.length() == 0) {
            return "(char) 0";
        }
        char ch = s2.charAt(0);
        return "((char) " + ch + ")";
    }

    public static String coerceToCharacter(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(java.lang.Character) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s2 + ", java.lang.Character.class)";
        }
        if (s2 == null || s2.length() == 0) {
            return "new java.lang.Character((char) 0)";
        }
        char ch = s2.charAt(0);
        return "new java.lang.Character((char) " + ch + ")";
    }

    public static String coerceToPrimitiveDouble(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToDouble(" + s2 + ")";
        }
        if (s2 == null || s2.length() == 0) {
            return "(double) 0";
        }
        return Double.valueOf(s2).toString();
    }

    public static String coerceToDouble(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(java.lang.Double) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s2 + ", Double.class)";
        }
        if (s2 == null || s2.length() == 0) {
            return "new java.lang.Double(0)";
        }
        return "new java.lang.Double(" + Double.valueOf(s2).toString() + ")";
    }

    public static String coerceToPrimitiveFloat(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToFloat(" + s2 + ")";
        }
        if (s2 == null || s2.length() == 0) {
            return "(float) 0";
        }
        return Float.valueOf(s2).toString() + "f";
    }

    public static String coerceToFloat(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(java.lang.Float) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s2 + ", java.lang.Float.class)";
        }
        if (s2 == null || s2.length() == 0) {
            return "new java.lang.Float(0)";
        }
        return "new java.lang.Float(" + Float.valueOf(s2).toString() + "f)";
    }

    public static String coerceToInt(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToInt(" + s2 + ")";
        }
        if (s2 == null || s2.length() == 0) {
            return "0";
        }
        return Integer.valueOf(s2).toString();
    }

    public static String coerceToInteger(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(java.lang.Integer) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s2 + ", java.lang.Integer.class)";
        }
        if (s2 == null || s2.length() == 0) {
            return "new java.lang.Integer(0)";
        }
        return "new java.lang.Integer(" + Integer.valueOf(s2).toString() + ")";
    }

    public static String coerceToPrimitiveShort(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToShort(" + s2 + ")";
        }
        if (s2 == null || s2.length() == 0) {
            return "(short) 0";
        }
        return "((short) " + Short.valueOf(s2).toString() + ")";
    }

    public static String coerceToShort(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(java.lang.Short) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s2 + ", java.lang.Short.class)";
        }
        if (s2 == null || s2.length() == 0) {
            return "new java.lang.Short((short) 0)";
        }
        return "new java.lang.Short(\"" + Short.valueOf(s2).toString() + "\")";
    }

    public static String coerceToPrimitiveLong(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToLong(" + s2 + ")";
        }
        if (s2 == null || s2.length() == 0) {
            return "(long) 0";
        }
        return Long.valueOf(s2).toString() + "l";
    }

    public static String coerceToLong(String s2, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(java.lang.Long) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s2 + ", java.lang.Long.class)";
        }
        if (s2 == null || s2.length() == 0) {
            return "new java.lang.Long(0)";
        }
        return "new java.lang.Long(" + Long.valueOf(s2).toString() + "l)";
    }

    public static InputStream getInputStream(String fname, Jar jar, JspCompilationContext ctxt) throws IOException {
        InputStream in = null;
        if (jar != null) {
            String jarEntryName = fname.substring(1, fname.length());
            in = jar.getInputStream(jarEntryName);
        } else {
            in = ctxt.getResourceAsStream(fname);
        }
        if (in == null) {
            throw new FileNotFoundException(Localizer.getMessage("jsp.error.file.not.found", fname));
        }
        return in;
    }

    public static InputSource getInputSource(String fname, Jar jar, JspCompilationContext ctxt) throws IOException {
        InputSource source;
        if (jar != null) {
            String jarEntryName = fname.substring(1, fname.length());
            source = new InputSource(jar.getInputStream(jarEntryName));
            source.setSystemId(jar.getURL(jarEntryName));
        } else {
            source = new InputSource(ctxt.getResourceAsStream(fname));
            source.setSystemId(ctxt.getResource(fname).toExternalForm());
        }
        return source;
    }

    public static String getTagHandlerClassName(String path, String urn, ErrorDispatcher err) throws JasperException {
        String className = null;
        int begin = 0;
        int index = path.lastIndexOf(".tag");
        if (index == -1) {
            err.jspError("jsp.error.tagfile.badSuffix", path);
        }
        if ((index = path.indexOf(WEB_INF_TAGS)) != -1) {
            className = Constants.TAG_FILE_PACKAGE_NAME + ".web.";
            begin = index + WEB_INF_TAGS.length();
        } else {
            index = path.indexOf(META_INF_TAGS);
            if (index != -1) {
                className = JspUtil.getClassNameBase(urn);
                begin = index + META_INF_TAGS.length();
            } else {
                err.jspError("jsp.error.tagfile.illegalPath", path);
            }
        }
        className = className + JspUtil.makeJavaPackage(path.substring(begin));
        return className;
    }

    private static String getClassNameBase(String urn) {
        StringBuilder base = new StringBuilder(Constants.TAG_FILE_PACKAGE_NAME + ".meta.");
        if (urn != null) {
            base.append(JspUtil.makeJavaPackage(urn));
            base.append('.');
        }
        return base.toString();
    }

    public static final String makeJavaPackage(String path) {
        String[] classNameComponents = JspUtil.split(path, "/");
        StringBuilder legalClassNames = new StringBuilder();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append(JspUtil.makeJavaIdentifier(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    private static final String[] split(String path, String pat) {
        Vector<String> comps = new Vector<String>();
        int pos = path.indexOf(pat);
        int start = 0;
        while (pos >= 0) {
            if (pos > start) {
                String comp = path.substring(start, pos);
                comps.add(comp);
            }
            start = pos + pat.length();
            pos = path.indexOf(pat, start);
        }
        if (start < path.length()) {
            comps.add(path.substring(start));
        }
        String[] result = new String[comps.size()];
        for (int i = 0; i < comps.size(); ++i) {
            result[i] = (String)comps.elementAt(i);
        }
        return result;
    }

    public static final String makeJavaIdentifier(String identifier) {
        return JspUtil.makeJavaIdentifier(identifier, true);
    }

    public static final String makeJavaIdentifierForAttribute(String identifier) {
        return JspUtil.makeJavaIdentifier(identifier, false);
    }

    private static final String makeJavaIdentifier(String identifier, boolean periodToUnderscore) {
        StringBuilder modifiedIdentifier = new StringBuilder(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch) && (ch != '_' || !periodToUnderscore)) {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.' && periodToUnderscore) {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(JspUtil.mangleChar(ch));
        }
        if (JspUtil.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    public static final String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }

    public static boolean isJavaKeyword(String key) {
        int i = 0;
        int j = javaKeywords.length;
        while (i < j) {
            int k = i + j >>> 1;
            int result = javaKeywords[k].compareTo(key);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return false;
    }

    static InputStreamReader getReader(String fname, String encoding, Jar jar, JspCompilationContext ctxt, ErrorDispatcher err) throws JasperException, IOException {
        return JspUtil.getReader(fname, encoding, jar, ctxt, err, 0);
    }

    static InputStreamReader getReader(String fname, String encoding, Jar jar, JspCompilationContext ctxt, ErrorDispatcher err, int skip) throws JasperException, IOException {
        InputStreamReader reader = null;
        InputStream in = JspUtil.getInputStream(fname, jar, ctxt);
        try {
            for (int i = 0; i < skip; ++i) {
                in.read();
            }
        }
        catch (IOException ioe) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
        try {
            reader = new InputStreamReader(in, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            err.jspError("jsp.error.unsupported.encoding", encoding);
        }
        return reader;
    }

    public static String toJavaSourceTypeFromTld(String type) {
        if (type == null || "void".equals(type)) {
            return "java.lang.Void.TYPE";
        }
        return type + ".class";
    }

    public static String toJavaSourceType(String type) {
        if (type.charAt(0) != '[') {
            return type;
        }
        int dims = 1;
        String t = null;
        for (int i = 1; i < type.length(); ++i) {
            if (type.charAt(i) == '[') {
                ++dims;
                continue;
            }
            switch (type.charAt(i)) {
                case 'Z': {
                    t = "boolean";
                    break;
                }
                case 'B': {
                    t = "byte";
                    break;
                }
                case 'C': {
                    t = "char";
                    break;
                }
                case 'D': {
                    t = "double";
                    break;
                }
                case 'F': {
                    t = "float";
                    break;
                }
                case 'I': {
                    t = "int";
                    break;
                }
                case 'J': {
                    t = "long";
                    break;
                }
                case 'S': {
                    t = "short";
                    break;
                }
                case 'L': {
                    t = type.substring(i + 1, type.indexOf(59));
                }
            }
            break;
        }
        if (t == null) {
            throw new IllegalArgumentException("Unable to extract type from [" + type + "]");
        }
        StringBuilder resultType = new StringBuilder(t);
        while (dims > 0) {
            resultType.append("[]");
            --dims;
        }
        return resultType.toString();
    }

    public static class ValidAttribute {
        private final String name;
        private final boolean mandatory;

        public ValidAttribute(String name, boolean mandatory) {
            this.name = name;
            this.mandatory = mandatory;
        }

        public ValidAttribute(String name) {
            this(name, false);
        }
    }
}

