/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.ArrayList;
import java.util.List;
import org.apache.jasper.compiler.SmapStratum;

public class SmapGenerator {
    private String outputFileName;
    private String defaultStratum = "Java";
    private final List<SmapStratum> strata = new ArrayList<SmapStratum>();
    private final List<String> embedded = new ArrayList<String>();
    private boolean doEmbedded = true;

    public synchronized void setOutputFileName(String x) {
        this.outputFileName = x;
    }

    public synchronized void setStratum(SmapStratum stratum) {
        this.addStratum(stratum, true);
    }

    @Deprecated
    public synchronized void addStratum(SmapStratum stratum, boolean defaultStratum) {
        this.strata.add(stratum);
        if (defaultStratum) {
            this.defaultStratum = stratum.getStratumName();
        }
    }

    @Deprecated
    public synchronized void addSmap(String smap, String stratumName) {
        this.embedded.add("*O " + stratumName + "\n" + smap + "*C " + stratumName + "\n");
    }

    @Deprecated
    public void setDoEmbedded(boolean status) {
        this.doEmbedded = status;
    }

    public synchronized String getString() {
        int i;
        if (this.outputFileName == null) {
            throw new IllegalStateException();
        }
        StringBuilder out = new StringBuilder();
        out.append("SMAP\n");
        out.append(this.outputFileName + '\n');
        out.append(this.defaultStratum + '\n');
        if (this.doEmbedded) {
            int nEmbedded = this.embedded.size();
            for (i = 0; i < nEmbedded; ++i) {
                out.append(this.embedded.get(i));
            }
        }
        int nStrata = this.strata.size();
        for (i = 0; i < nStrata; ++i) {
            SmapStratum s2 = this.strata.get(i);
            out.append(s2.getString());
        }
        out.append("*E\n");
        return out.toString();
    }

    public String toString() {
        return this.getString();
    }

    public static void main(String[] args) {
        SmapGenerator g2 = new SmapGenerator();
        g2.setOutputFileName("foo.java");
        SmapStratum s2 = new SmapStratum();
        s2.addFile("foo.jsp");
        s2.addFile("bar.jsp", "/foo/foo/bar.jsp");
        s2.addLineData(1, "foo.jsp", 1, 1, 1);
        s2.addLineData(2, "foo.jsp", 1, 6, 1);
        s2.addLineData(3, "foo.jsp", 2, 10, 5);
        s2.addLineData(20, "bar.jsp", 1, 30, 1);
        g2.addStratum(s2, true);
        System.out.print(g2);
        System.out.println("---");
        SmapGenerator embedded = new SmapGenerator();
        embedded.setOutputFileName("blargh.tier2");
        s2 = new SmapStratum("Tier2");
        s2.addFile("1.tier2");
        s2.addLineData(1, "1.tier2", 1, 1, 1);
        embedded.addStratum(s2, true);
        g2.addSmap(embedded.toString(), "JSP");
        System.out.println(g2);
    }
}

