/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogXF;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public final class LogMF
extends LogXF {
    private static NumberFormat numberFormat = null;
    private static Locale numberLocale = null;
    private static DateFormat dateFormat = null;
    private static Locale dateLocale = null;
    private static final String FQCN = LogMF.class.getName();

    private LogMF() {
    }

    private static synchronized String formatNumber(Object n) {
        Locale currentLocale = Locale.getDefault();
        if (currentLocale != numberLocale || numberFormat == null) {
            numberLocale = currentLocale;
            numberFormat = NumberFormat.getInstance(currentLocale);
        }
        return numberFormat.format(n);
    }

    private static synchronized String formatDate(Object d) {
        Locale currentLocale = Locale.getDefault();
        if (currentLocale != dateLocale || dateFormat == null) {
            dateLocale = currentLocale;
            dateFormat = DateFormat.getDateTimeInstance(3, 3, currentLocale);
        }
        return dateFormat.format(d);
    }

    private static String formatObject(Object arg0) {
        if (arg0 instanceof String) {
            return arg0.toString();
        }
        if (arg0 instanceof Double || arg0 instanceof Float) {
            return LogMF.formatNumber(arg0);
        }
        if (arg0 instanceof Date) {
            return LogMF.formatDate(arg0);
        }
        return String.valueOf(arg0);
    }

    private static boolean isSimple(String pattern) {
        if (pattern.indexOf(39) != -1) {
            return false;
        }
        int pos = pattern.indexOf(123);
        while (pos != -1) {
            if (pos + 2 >= pattern.length() || pattern.charAt(pos + 2) != '}' || pattern.charAt(pos + 1) < '0' || pattern.charAt(pos + 1) > '9') {
                return false;
            }
            pos = pattern.indexOf(123, pos + 1);
        }
        return true;
    }

    private static String format(String pattern, Object[] arguments) {
        if (pattern == null) {
            return null;
        }
        if (LogMF.isSimple(pattern)) {
            String[] formatted = new String[10];
            int prev = 0;
            String retval = "";
            int pos = pattern.indexOf(123);
            while (pos >= 0) {
                if (pos + 2 < pattern.length() && pattern.charAt(pos + 2) == '}' && pattern.charAt(pos + 1) >= '0' && pattern.charAt(pos + 1) <= '9') {
                    int index = pattern.charAt(pos + 1) - 48;
                    retval = retval + pattern.substring(prev, pos);
                    if (formatted[index] == null) {
                        formatted[index] = arguments == null || index >= arguments.length ? pattern.substring(pos, pos + 3) : LogMF.formatObject(arguments[index]);
                    }
                    retval = retval + formatted[index];
                    prev = pos + 3;
                    pos = pattern.indexOf(123, prev);
                    continue;
                }
                pos = pattern.indexOf(123, pos + 1);
            }
            retval = retval + pattern.substring(prev);
            return retval;
        }
        try {
            return MessageFormat.format(pattern, arguments);
        }
        catch (IllegalArgumentException ex) {
            return pattern;
        }
    }

    private static String format(String pattern, Object arg0) {
        if (pattern == null) {
            return null;
        }
        if (LogMF.isSimple(pattern)) {
            String formatted = null;
            int prev = 0;
            String retval = "";
            int pos = pattern.indexOf(123);
            while (pos >= 0) {
                if (pos + 2 < pattern.length() && pattern.charAt(pos + 2) == '}' && pattern.charAt(pos + 1) >= '0' && pattern.charAt(pos + 1) <= '9') {
                    int index = pattern.charAt(pos + 1) - 48;
                    retval = retval + pattern.substring(prev, pos);
                    if (index != 0) {
                        retval = retval + pattern.substring(pos, pos + 3);
                    } else {
                        if (formatted == null) {
                            formatted = LogMF.formatObject(arg0);
                        }
                        retval = retval + formatted;
                    }
                    prev = pos + 3;
                    pos = pattern.indexOf(123, prev);
                    continue;
                }
                pos = pattern.indexOf(123, pos + 1);
            }
            retval = retval + pattern.substring(prev);
            return retval;
        }
        try {
            return MessageFormat.format(pattern, arg0);
        }
        catch (IllegalArgumentException ex) {
            return pattern;
        }
    }

    private static String format(String resourceBundleName, String key, Object[] arguments) {
        String pattern;
        if (resourceBundleName != null) {
            try {
                ResourceBundle bundle2 = ResourceBundle.getBundle(resourceBundleName);
                pattern = bundle2.getString(key);
            }
            catch (Exception ex) {
                pattern = key;
            }
        } else {
            pattern = key;
        }
        return LogMF.format(pattern, arguments);
    }

    private static void forcedLog(Logger logger2, Level level, String msg) {
        logger2.callAppenders(new LoggingEvent(FQCN, (Category)logger2, (Priority)level, (Object)msg, null));
    }

    private static void forcedLog(Logger logger2, Level level, String msg, Throwable t) {
        logger2.callAppenders(new LoggingEvent(FQCN, (Category)logger2, (Priority)level, (Object)msg, t));
    }

    public static void trace(Logger logger2, String pattern, Object[] arguments) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, arguments));
        }
    }

    public static void debug(Logger logger2, String pattern, Object[] arguments) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, arguments));
        }
    }

    public static void info(Logger logger2, String pattern, Object[] arguments) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, arguments));
        }
    }

    public static void warn(Logger logger2, String pattern, Object[] arguments) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, arguments));
        }
    }

    public static void error(Logger logger2, String pattern, Object[] arguments) {
        if (logger2.isEnabledFor(Level.ERROR)) {
            LogMF.forcedLog(logger2, Level.ERROR, LogMF.format(pattern, arguments));
        }
    }

    public static void fatal(Logger logger2, String pattern, Object[] arguments) {
        if (logger2.isEnabledFor(Level.FATAL)) {
            LogMF.forcedLog(logger2, Level.FATAL, LogMF.format(pattern, arguments));
        }
    }

    public static void trace(Logger logger2, Throwable t, String pattern, Object[] arguments) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, arguments), t);
        }
    }

    public static void debug(Logger logger2, Throwable t, String pattern, Object[] arguments) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, arguments), t);
        }
    }

    public static void info(Logger logger2, Throwable t, String pattern, Object[] arguments) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, arguments), t);
        }
    }

    public static void warn(Logger logger2, Throwable t, String pattern, Object[] arguments) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, arguments), t);
        }
    }

    public static void error(Logger logger2, Throwable t, String pattern, Object[] arguments) {
        if (logger2.isEnabledFor(Level.ERROR)) {
            LogMF.forcedLog(logger2, Level.ERROR, LogMF.format(pattern, arguments), t);
        }
    }

    public static void fatal(Logger logger2, Throwable t, String pattern, Object[] arguments) {
        if (logger2.isEnabledFor(Level.FATAL)) {
            LogMF.forcedLog(logger2, Level.FATAL, LogMF.format(pattern, arguments), t);
        }
    }

    public static void trace(Logger logger2, String pattern, boolean argument) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger2, String pattern, char argument) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger2, String pattern, byte argument) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger2, String pattern, short argument) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger2, String pattern, int argument) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger2, String pattern, long argument) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger2, String pattern, float argument) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger2, String pattern, double argument) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger2, String pattern, Object argument) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, argument));
        }
    }

    public static void trace(Logger logger2, String pattern, Object arg0, Object arg1) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.toArray(arg0, arg1)));
        }
    }

    public static void trace(Logger logger2, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void trace(Logger logger2, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger2.isEnabledFor(TRACE)) {
            LogMF.forcedLog(logger2, TRACE, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void debug(Logger logger2, String pattern, boolean argument) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger2, String pattern, char argument) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger2, String pattern, byte argument) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger2, String pattern, short argument) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger2, String pattern, int argument) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger2, String pattern, long argument) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger2, String pattern, float argument) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger2, String pattern, double argument) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger2, String pattern, Object argument) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, argument));
        }
    }

    public static void debug(Logger logger2, String pattern, Object arg0, Object arg1) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.toArray(arg0, arg1)));
        }
    }

    public static void debug(Logger logger2, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void debug(Logger logger2, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger2.isDebugEnabled()) {
            LogMF.forcedLog(logger2, Level.DEBUG, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void info(Logger logger2, String pattern, boolean argument) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void info(Logger logger2, String pattern, char argument) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void info(Logger logger2, String pattern, byte argument) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void info(Logger logger2, String pattern, short argument) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void info(Logger logger2, String pattern, int argument) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void info(Logger logger2, String pattern, long argument) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void info(Logger logger2, String pattern, float argument) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void info(Logger logger2, String pattern, double argument) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void info(Logger logger2, String pattern, Object argument) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, argument));
        }
    }

    public static void info(Logger logger2, String pattern, Object arg0, Object arg1) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.toArray(arg0, arg1)));
        }
    }

    public static void info(Logger logger2, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void info(Logger logger2, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger2.isInfoEnabled()) {
            LogMF.forcedLog(logger2, Level.INFO, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void warn(Logger logger2, String pattern, boolean argument) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger2, String pattern, char argument) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger2, String pattern, byte argument) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger2, String pattern, short argument) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger2, String pattern, int argument) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger2, String pattern, long argument) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger2, String pattern, float argument) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger2, String pattern, double argument) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger2, String pattern, Object argument) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, argument));
        }
    }

    public static void warn(Logger logger2, String pattern, Object arg0, Object arg1) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.toArray(arg0, arg1)));
        }
    }

    public static void warn(Logger logger2, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void warn(Logger logger2, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger2.isEnabledFor(Level.WARN)) {
            LogMF.forcedLog(logger2, Level.WARN, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, Object[] parameters) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, parameters));
        }
    }

    public static void log(Logger logger2, Level level, Throwable t, String pattern, Object[] parameters) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, parameters), t);
        }
    }

    public static void log(Logger logger2, Level level, String pattern, Object param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(param1)));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, boolean param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, byte param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, char param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, short param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, int param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, long param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, float param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, double param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, Object arg0, Object arg1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(arg0, arg1)));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void log(Logger logger2, Level level, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(pattern, LogMF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, Object[] parameters) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, parameters));
        }
    }

    public static void logrb(Logger logger2, Level level, Throwable t, String bundleName, String key, Object[] parameters) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, parameters), t);
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, Object param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(param1)));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, boolean param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, char param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, byte param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, short param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, int param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, long param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, float param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, double param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(LogMF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, Object param0, Object param1) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(param0, param1)));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, Object param0, Object param1, Object param2) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(param0, param1, param2)));
        }
    }

    public static void logrb(Logger logger2, Level level, String bundleName, String key, Object param0, Object param1, Object param2, Object param3) {
        if (logger2.isEnabledFor(level)) {
            LogMF.forcedLog(logger2, level, LogMF.format(bundleName, key, LogMF.toArray(param0, param1, param2, param3)));
        }
    }
}

