/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.logger.store;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.appops.core.annotation.Config;
import org.appops.logging.logger.config.LoggerConfig;
import org.appops.logging.logger.store.LogStore;
import org.appops.logging.meta.Level;
import org.appops.logging.meta.LogMeta;
import org.appops.logging.meta.LogMetaList;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;

public class FileLogStoreImpl
implements LogStore {
    private Marshaller marshaller;
    private LoggerConfig config;

    @Override
    public void addLogRecord(LogMeta logRecord) {
        String logMetaJson = this.getMarshaller().marshall(logRecord, this.getMarshallerType());
        this.saveMeta(logMetaJson);
    }

    private void saveMeta(String meta) {
        try {
            String path = this.getStorageFilePath();
            File file = new File(path);
            if (path.contains(File.separator)) {
                file.getParentFile().mkdirs();
            }
            if (this.getMaxFileSize(this.getConfig().getStorage().getMaxFileSize()) > file.length()) {
                FileWriter writer = new FileWriter(file, true);
                writer.write(meta + ",");
                writer.close();
            } else {
                this.removeOlderLogs();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public Collection<LogMeta> getAllLogRecords() {
        try {
            String data = this.readDataFromFile();
            if (data != null) {
                String allLogs = this.formatLogs(data);
                List returnMetaList = this.getMarshaller().unmarshall(allLogs, LogMetaList.class, this.getMarshallerType());
                return returnMetaList;
            }
        }
        catch (Exception e) {
            System.out.println("Exception occured while fetching logs from store " + e);
        }
        return null;
    }

    @Override
    public void removeOlderLogs() {
        try {
            Collection<LogMeta> logs = this.getAllLogRecords();
            ArrayList<LogMeta> allLogs = new ArrayList<LogMeta>(logs);
            for (LogMeta logMeta : allLogs) {
                if (this.isValid(logMeta.datetime())) continue;
                logs.remove(logMeta);
            }
            String filterdLogs = this.getMarshaller().marshall(logs, DescriptorType.JSON);
            filterdLogs = filterdLogs.substring(1, filterdLogs.length() - 1);
            new PrintWriter(this.getStorageFilePath()).close();
            this.saveMeta(filterdLogs);
        }
        catch (Exception e) {
            System.out.println("Exception occured while removing older logs from store " + e);
        }
    }

    private boolean isValid(String datetime) {
        SimpleDateFormat format = new SimpleDateFormat("MMM dd,yyyy", Locale.ENGLISH);
        try {
            Date metaDate = format.parse(datetime);
            Date ttl = format.parse(this.getTtl());
            if (metaDate.after(ttl)) {
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String readDataFromFile() {
        try {
            String data = new String(Files.readAllBytes(Paths.get(this.getStorageFilePath(), new String[0])));
            return data;
        }
        catch (Exception e) {
            System.out.println("Exception occured in " + this.getClass().getCanonicalName() + ":readDataFromFile() " + e);
            return null;
        }
    }

    private String formatLogs(String data) {
        if (data != null && !data.isEmpty()) {
            if (data.endsWith(",")) {
                data = data.substring(0, data.length() - 1);
            }
            data = "[" + data + "]";
            return data;
        }
        return null;
    }

    private String getTtl() {
        return this.getConfig().getStorage().getTtl();
    }

    private String getStorageFilePath() {
        return this.getConfig().getStorage().getFilepath();
    }

    private DescriptorType getMarshallerType() {
        try {
            if (this.getStorageFilePath() != null) {
                return DescriptorType.fromExtension(this.getStorageFilePath());
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return DescriptorType.JSON;
    }

    private long getMaxFileSize(String maxFileSizeString) {
        int defaultSize = 0x6400000;
        try {
            if (maxFileSizeString != null) {
                String unit = maxFileSizeString.substring(maxFileSizeString.length() - 2, maxFileSizeString.length());
                int size = Integer.parseInt(maxFileSizeString.substring(0, maxFileSizeString.length() - 2));
                switch (unit.toUpperCase()) {
                    case "KB": {
                        return size * 1024;
                    }
                    case "MB": {
                        return size * 1024 * 1024;
                    }
                    case "GB": {
                        if (size <= 2) {
                            return size * 1024 * 1024 * 1024;
                        }
                        return defaultSize;
                    }
                }
                return defaultSize;
            }
        }
        catch (Exception e) {
            System.out.println("Exception occured while converting file size it will use default size." + e);
        }
        return defaultSize;
    }

    @Override
    public Collection<LogMeta> filterByKeyword(String keyword) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        for (LogMeta logRecord : this.getAllLogRecords()) {
            Map<String, Object> logMetaMap = logRecord.getMetaMap();
            for (Object value : logMetaMap.values()) {
                if (!String.valueOf(value).contains(keyword)) continue;
                listToReturn.add(logRecord);
            }
        }
        return listToReturn;
    }

    @Override
    public Collection<LogMeta> filterByLevel(Level expectedLevel) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        if (expectedLevel == null) {
            return listToReturn;
        }
        for (LogMeta logRecord : this.getAllLogRecords()) {
            String level = (String)logRecord.getMetaMap().get(LogMeta.LEVEL.value());
            if (!expectedLevel.name().equals(level) && !expectedLevel.name().equals(Level.ALL.name())) continue;
            listToReturn.add(logRecord);
        }
        return listToReturn;
    }

    @Override
    public Collection<LogMeta> getLogRecordsByPage(Integer startIndex, Integer pageSize) {
        return null;
    }

    @Override
    public Collection<LogMeta> getLogRecordsByStartDate(String startDateOfLog) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        Date startDate = null;
        startDateOfLog = startDateOfLog.substring(0, 9);
        SimpleDateFormat format = new SimpleDateFormat("MMMddyyyy", Locale.ENGLISH);
        try {
            startDate = format.parse(startDateOfLog);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        for (LogMeta logRecord : this.getAllLogRecords()) {
            String dateValue = logRecord.datetime();
            dateValue = dateValue.substring(0, 12);
            dateValue = dateValue.replace(",", "");
            SimpleDateFormat format2 = new SimpleDateFormat("MMM ddyyyy", Locale.ENGLISH);
            try {
                Date date2 = format2.parse(dateValue);
                if (date2.compareTo(startDate) < 0) continue;
                listToReturn.add(logRecord);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return listToReturn;
    }

    @Override
    public Collection<LogMeta> getLogRecords(String startDate, String endDate) {
        return this.filterByDateTime(startDate, endDate, null, null);
    }

    @Override
    public Collection<LogMeta> getLogRecordsByStartTime(String startTime) {
        return this.filterByDateTime(null, null, startTime, null);
    }

    @Override
    public Collection<LogMeta> getLogRecordsByStartTimeEndTime(String startTime, String endTime) {
        return this.filterByDateTime(null, null, startTime, endTime);
    }

    @Override
    public Collection<LogMeta> getLogRecordsByDateAndTime(String startDate, String endDate, String startTime, String endTime) {
        return this.filterByDateTime(startDate, endDate, startTime, endTime);
    }

    private Collection<LogMeta> filterByDateTime(String startDateString, String endDateString, String startTime, String endTime) {
        ArrayList<LogMeta> listToReturn = new ArrayList<LogMeta>();
        Date startDate = null;
        Date endDate = null;
        SimpleDateFormat formatter = new SimpleDateFormat("MMMddyyyyhh:mm", Locale.ENGLISH);
        try {
            if (startDateString != null) {
                startDateString = this.getStartDate(startDateString, startTime);
                startDate = formatter.parse(startDateString);
            }
            endDateString = this.getEndString(endDateString, endTime);
            endDate = formatter.parse(endDateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat format2 = new SimpleDateFormat("MMM dd,yyyy hh:mm:ss aa", Locale.ENGLISH);
        for (LogMeta logRecord : this.getAllLogRecords()) {
            try {
                Date logMetaDate = format2.parse(logRecord.datetime());
                if (logMetaDate.compareTo(startDate) < 0 || logMetaDate.compareTo(endDate) > 0) continue;
                listToReturn.add(logRecord);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return listToReturn;
    }

    private String getEndString(String endDateString, String endTime) {
        LocalTime endLocalTime = null;
        endDateString = endDateString == null || endDateString.isEmpty() ? new SimpleDateFormat("MMMddyyyy").format(new Date()) : endDateString.substring(0, 9);
        endLocalTime = endTime == null || endTime.isEmpty() ? LocalTime.now() : LocalTime.parse(endTime);
        return endDateString + endLocalTime;
    }

    private String getStartDate(String startDateString, String startTime) {
        startDateString = startDateString.substring(0, 9);
        startDateString = startTime != null && !startTime.isEmpty() ? startDateString + startTime : startDateString + "00:00";
        return startDateString;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public LoggerConfig getConfig() {
        return this.config;
    }

    @Inject
    public void setConfig(@Config LoggerConfig config) {
        this.config = config;
    }
}

