/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.deployment.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.appops.configuration.ContainerConfig;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.service.exception.DeploymentException;

public class DockerDeploymentManager {
    private DockerClient dockerClient;

    public DockerDeploymentManager() {
        this.initialize();
    }

    private void initialize() {
        this.setDockerClient(DockerClientBuilder.getInstance().build());
    }

    public void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }

    public Set<String> performDeployment(ServiceConfiguration config) {
        HashSet<String> containerIds = new HashSet<String>();
        ContainerConfig container = config.getContainerConfig();
        String baseDir = container.getDockerFileOrBaseDirectory().getAbsolutePath();
        try (BuildImageCmd cmd = this.getDockerClient().buildImageCmd(new File(baseDir));){
            String imageId = cmd.exec(this.createBuildImageCallback()).awaitImageId();
            try (CreateContainerCmd createContainerCmd = this.getDockerClient().createContainerCmd(imageId);){
                String contaienerId = createContainerCmd.withName(imageId).withHostConfig(HostConfig.newHostConfig().withNetworkMode("host")).exec().getId();
                this.getDockerClient().startContainerCmd(contaienerId).exec();
                containerIds.add(contaienerId);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Unable  to perform docker deployment for ->" + config.serviceUrl());
        }
        return containerIds;
    }

    public BuildImageResultCallback createBuildImageCallback() {
        return new BuildImageResultCallback();
    }

    public DockerClient getDockerClient() {
        return this.dockerClient;
    }
}

