/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.request;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.appops.core.mime.MimeType;
import org.appops.core.service.OpParameterMap;
import org.appops.core.service.RequestMethod;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.logging.logger.Logger;
import org.appops.logging.meta.Level;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.service.exception.InvocationException;
import org.appops.service.invocation.OperationInvoker;
import org.appops.service.request.RestResponseWriter;
import org.appops.slim.base.api.ServiceMetaManager;

public class ServiceApiFilter
implements Filter {
    @Inject
    private Provider<OperationInvoker> invoker;
    @Inject
    private Provider<RestResponseWriter> responseWriter;
    @Inject
    private Logger logger;
    @Inject
    private Marshaller marshaller;
    private static final String MULTIPART_CONFIG_ELEMENT = "org.eclipse.jetty.multipartConfig";
    static final String RESPONSE_TYPE_PARAMETER = "RESPONSE_TYPE";
    static final String HEAD_REQUEST = "HEAD_REQUEST";
    private File file = null;
    private ArrayList<File> filesList = null;
    @Inject
    private ServiceMetaManager serviceMetaManager;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String reqUri = req.getRequestURI();
        if (reqUri.contains("/Op/")) {
            reqUri = reqUri.replaceAll("/Op/", "/");
        }
        String serviceName = this.getServiceNameFromReqUri(reqUri);
        ServiceMeta serviceMeta = null;
        if (serviceName != null && !serviceName.isEmpty()) {
            try {
                serviceMeta = this.serviceMetaManager.getServiceMeta(serviceName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (serviceMeta != null) {
            String requestedMethod = req.getMethod();
            if (RequestMethod.GET.name().equals(requestedMethod)) {
                this.doGetRequest(req, resp, reqUri);
            } else if (RequestMethod.POST.name().equals(requestedMethod)) {
                this.doPostRequest(req, resp, reqUri);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void doGetRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri) {
        try {
            String[] serviceAndPathArr = this.extractServiceAndOpPath(reqUri);
            Object result = this.invoker.get().invoke(serviceAndPathArr[0], serviceAndPathArr[1]);
            if (result != null) {
                this.responseWriter.get().sendResponse(resp, result, req.getParameter(RESPONSE_TYPE_PARAMETER));
            }
        }
        catch (Exception e) {
            String msg = e.getMessage() != null ? e.getMessage() : Arrays.toString(e.getStackTrace());
            this.sendErronInResponse(resp, 500, msg);
        }
    }

    public void doPostRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri) {
        boolean hasFormData = req.getContentType() != null && !req.getContentType().isEmpty() && req.getContentType().toLowerCase().contains(((String)MimeType.MULTIPART.value()).toLowerCase());
        try {
            String[] serviceAndPathArr = this.extractServiceAndOpPath(reqUri);
            OpParameterMap parameterMap = null;
            parameterMap = hasFormData ? this.convertFormDataToParamMap(req.getParts()) : this.unmarshallParameterMap(req);
            Object result = this.invoker.get().invoke(serviceAndPathArr[0], serviceAndPathArr[1], parameterMap);
            if (result != null) {
                this.responseWriter.get().sendResponse(resp, result, req.getParameter(RESPONSE_TYPE_PARAMETER));
            }
            if (this.filesList != null) {
                for (File file : this.filesList) {
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            this.sendErronInResponse(resp, 500, e.getMessage());
        }
    }

    private String getServiceNameFromReqUri(String reqUri) {
        if (reqUri.startsWith("/")) {
            reqUri = reqUri.substring(1);
        }
        if (reqUri.contains(".html")) {
            int indexOfHtml = reqUri.indexOf(".html");
            reqUri = reqUri.substring(indexOfHtml + 5);
        } else if (reqUri.contains(".jsp")) {
            int indexOfJsp = reqUri.indexOf(".jsp");
            reqUri = reqUri.substring(indexOfJsp + 4);
        }
        if (reqUri.startsWith("/")) {
            reqUri = reqUri.substring(1);
        }
        String[] requestPathArr = reqUri.split("/");
        return requestPathArr[0];
    }

    public void sendErronInResponse(HttpServletResponse resp, int errorCode, String message) {
        try {
            if (message.contains("Invalid request :")) {
                errorCode = 400;
            }
            resp.sendError(errorCode, message);
        }
        catch (Exception ex) {
            this.logger.withLevel(Level.ERROR).withMessage(ex.toString()).log();
        }
    }

    private String[] extractServiceAndOpPath(String requestPath) {
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (requestPath.isEmpty()) {
            this.throwRequestPatternException();
        }
        String[] requestPathArr = requestPath.split("/", 2);
        return requestPathArr;
    }

    public void throwRequestPatternException() {
        throw new InvocationException("Invalid request : minimum required pattern is /Op/<service_name>/<operation_info> An operation_info can be name or path of an operation.");
    }

    void setResponseWriter(Provider<RestResponseWriter> responseWriter) {
        this.responseWriter = responseWriter;
    }

    void setInvoker(Provider<OperationInvoker> invoker) {
        this.invoker = invoker;
    }

    void setLogger(Logger logger2) {
        this.logger = logger2;
    }

    private OpParameterMap convertFormDataToParamMap(Collection<Part> parts) throws IOException {
        OpParameterMap parameterMap = new OpParameterMap();
        int order = 0;
        this.filesList = new ArrayList();
        for (Part part : parts) {
            Object value = null;
            if (part.getSubmittedFileName() != null) {
                value = this.convertPartToFile(part);
                this.filesList.add((File)value);
            } else {
                value = IOUtils.toString(part.getInputStream(), StandardCharsets.UTF_8.name());
            }
            parameterMap.addParameter(order++, part.getName(), value);
        }
        return parameterMap;
    }

    public File convertPartToFile(Part part) {
        try {
            String path = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() + "/src/main/resources/";
            String fileName = part.getName();
            this.file = new File(path + fileName);
            FileUtils.copyInputStreamToFile(part.getInputStream(), this.file);
            return this.file;
        }
        catch (Exception e) {
            throw new InvocationException(e.getMessage());
        }
    }

    private OpParameterMap unmarshallParameterMap(HttpServletRequest request) {
        StringBuilder jb = new StringBuilder();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            throw new InvocationException("Unable to read request data");
        }
        String data = jb.toString();
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            OpParameterMap parameterMap = this.marshaller.unmarshall(data, OpParameterMap.class, DescriptorType.JSON);
            return parameterMap;
        }
        catch (Exception e) {
            throw new InvocationException("Unable to unmarshall post request data.", e.getCause());
        }
    }

    @Override
    public void destroy() {
    }
}

