/*
 * Decompiled with CFR 0.152.
 */
package org.appops.slim.base.invocation;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.appops.core.service.annotation.Service;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.core.service.meta.InterfaceMeta;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.core.service.signature.ServiceOpSignatureBuilder;
import org.appops.slim.base.exception.InvocationException;
import org.appops.slim.base.invocation.ApiRestInvoker;

public class ApiProxyInvocationHandler
implements InvocationHandler {
    private ApiRestInvoker apiRestInvoker;
    private ServiceOpSignatureBuilder signatureBuilder;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ServiceOpMeta opMeta = this.createOpMeta(method, args);
        return this.getApiRestInvoker().invokeRest(opMeta);
    }

    public ServiceOpMeta createOpMeta(Method method, Object[] args) {
        ServiceOpMeta opMeta = new ServiceOpMeta();
        opMeta.setName(method.getName());
        ServiceOp opAnnotation = method.getAnnotation(ServiceOp.class);
        if (opAnnotation == null) {
            throw new InvocationException("Cannot invoke operation, ServiceOp annotation is absent on method ->" + method.getName());
        }
        opMeta.setFriendly(opAnnotation.friendly());
        opMeta.setPath(opAnnotation.path());
        opMeta.setResultTypeName(method.getReturnType().getCanonicalName());
        opMeta.setMethod(opAnnotation.method());
        Parameter[] parameters = method.getParameters();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                org.appops.core.service.Parameter parameter = new org.appops.core.service.Parameter(i, parameters[i].getName(), args[i]);
                parameter.setTypeName(method.getParameterTypes()[i].getCanonicalName());
                opMeta.addParameter(parameter);
            }
        }
        InterfaceMeta interfaceMeta = new InterfaceMeta();
        interfaceMeta.setName(method.getDeclaringClass().getSimpleName());
        interfaceMeta.setQualifiedClassName(method.getDeclaringClass().getCanonicalName());
        opMeta.setParent(interfaceMeta);
        interfaceMeta.addOperation(opMeta);
        String serviceName = null;
        for (Annotation annotation : method.getDeclaringClass().getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Service.class)) continue;
            serviceName = annotation.annotationType().getSimpleName();
            break;
        }
        if (serviceName == null) {
            throw new InvocationException("Cannot invoke operation, unable to locate service name for method ->" + method.getName());
        }
        ServiceMeta serviceMeta = new ServiceMeta(serviceName);
        interfaceMeta.setParent(serviceMeta);
        return opMeta;
    }

    public ApiRestInvoker getApiRestInvoker() {
        return this.apiRestInvoker;
    }

    @Inject
    public void setApiRestInvoker(ApiRestInvoker apiRestInvoker) {
        this.apiRestInvoker = apiRestInvoker;
    }

    public ServiceOpSignatureBuilder getSignatureBuilder() {
        return this.signatureBuilder;
    }

    @Inject
    public void setSignatureBuilder(ServiceOpSignatureBuilder signatureBuilder) {
        this.signatureBuilder = signatureBuilder;
    }
}

