/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ObjectUtils {
    public static boolean areComparable(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return ObjectUtils.isComparable(o1) && ObjectUtils.isComparable(o2) && (o1.getClass().isAssignableFrom(o2.getClass()) || o2.getClass().isAssignableFrom(o1.getClass()));
    }

    public static boolean isComparable(Object object) {
        return object instanceof Comparable;
    }

    public static <T> T invokeMethod(String name, Object object, Object ... parms) {
        if (object == null) {
            return null;
        }
        Class[] parmTypes = new Class[parms.length];
        int i = 0;
        for (Object parameter : parms) {
            parmTypes[i++] = parameter.getClass();
        }
        Method m3 = null;
        try {
            m3 = object.getClass().getDeclaredMethod(name, parmTypes);
            m3.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            return (T)m3.invoke(object, parms);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectUtils() {
    }
}

