/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.pipeline;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.exception.DefaultExceptionMapper;
import org.restexpress.exception.ExceptionMapping;
import org.restexpress.exception.ExceptionUtils;
import org.restexpress.exception.ServiceException;
import org.restexpress.pipeline.MessageContext;
import org.restexpress.pipeline.MessageObserver;
import org.restexpress.pipeline.Postprocessor;
import org.restexpress.pipeline.Preprocessor;
import org.restexpress.response.HttpResponseWriter;
import org.restexpress.route.Action;
import org.restexpress.route.RouteResolver;
import org.restexpress.serialization.SerializationProvider;
import org.restexpress.serialization.SerializationSettings;
import org.restexpress.util.HttpSpecification;

@ChannelHandler.Sharable
public class DefaultRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final AttributeKey<MessageContext> CONTEXT_KEY = AttributeKey.valueOf("context");
    private RouteResolver routeResolver;
    private SerializationProvider serializationProvider;
    private HttpResponseWriter responseWriter;
    private List<Preprocessor> preprocessors = new ArrayList<Preprocessor>();
    private List<Postprocessor> postprocessors = new ArrayList<Postprocessor>();
    private List<Postprocessor> finallyProcessors = new ArrayList<Postprocessor>();
    private ExceptionMapping exceptionMap = new DefaultExceptionMapper();
    private List<MessageObserver> messageObservers = new ArrayList<MessageObserver>();
    private boolean shouldEnforceHttpSpec = true;

    public DefaultRequestHandler(RouteResolver routeResolver, SerializationProvider serializationProvider, HttpResponseWriter responseWriter, boolean enforceHttpSpec) {
        this.routeResolver = routeResolver;
        this.serializationProvider = serializationProvider;
        this.setResponseWriter(responseWriter);
        this.shouldEnforceHttpSpec = enforceHttpSpec;
    }

    public void addMessageObserver(MessageObserver ... observers) {
        for (MessageObserver observer : observers) {
            if (this.messageObservers.contains(observer)) continue;
            this.messageObservers.add(observer);
        }
    }

    public <T extends Throwable, U extends ServiceException> DefaultRequestHandler mapException(Class<T> from, Class<U> to) {
        this.exceptionMap.map(from, to);
        return this;
    }

    public DefaultRequestHandler setExceptionMap(ExceptionMapping map) {
        this.exceptionMap = map;
        return this;
    }

    public HttpResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setResponseWriter(HttpResponseWriter writer) {
        this.responseWriter = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest event) throws Exception {
        MessageContext context = this.createInitialContext(ctx, event);
        try {
            this.processRequest(ctx, context);
        }
        catch (Throwable t) {
            this.handleRestExpressException(ctx, t);
        }
        finally {
            this.notifyComplete(context);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
        super.channelReadComplete(ctx);
    }

    private void processRequest(ChannelHandlerContext ctx, MessageContext context) throws Throwable {
        this.notifyReceived(context);
        this.resolveRoute(context);
        this.resolveResponseProcessor(context);
        this.invokePreprocessors(this.preprocessors, context.getRequest());
        Object result = context.getAction().invoke(context.getRequest(), context.getResponse());
        if (result != null) {
            context.getResponse().setBody(result);
        }
        this.invokePostprocessors(this.postprocessors, context.getRequest(), context.getResponse());
        this.serializeResponse(context, false);
        this.enforceHttpSpecification(context);
        this.invokeFinallyProcessors(this.finallyProcessors, context.getRequest(), context.getResponse());
        this.writeResponse(ctx, context);
        this.notifySuccess(context);
    }

    private void resolveResponseProcessor(MessageContext context) {
        SerializationSettings s2 = this.serializationProvider.resolveResponse(context.getRequest(), context.getResponse(), false);
        context.setSerializationSettings(s2);
    }

    private void enforceHttpSpecification(MessageContext context) {
        if (this.shouldEnforceHttpSpec) {
            HttpSpecification.enforce(context.getResponse());
        }
    }

    private void handleRestExpressException(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        MessageContext context = ctx.attr(CONTEXT_KEY).get();
        Throwable rootCause = this.mapServiceException(cause);
        if (rootCause != null) {
            context.setHttpStatus(((ServiceException)rootCause).getHttpStatus());
            if (ServiceException.class.isAssignableFrom(rootCause.getClass())) {
                ((ServiceException)rootCause).augmentResponse(context.getResponse());
            }
        } else {
            rootCause = ExceptionUtils.findRootCause(cause);
            context.setHttpStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        context.setException(rootCause);
        this.notifyException(context);
        this.serializeResponse(context, true);
        this.invokeFinallyProcessors(this.finallyProcessors, context.getRequest(), context.getResponse());
        this.writeResponse(ctx, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) throws Exception {
        try {
            MessageContext messageContext = ctx.attr(CONTEXT_KEY).get();
            if (messageContext != null) {
                messageContext.setException(throwable.getCause() != null ? throwable.getCause() : throwable);
                this.notifyException(messageContext);
            }
        }
        catch (Throwable t) {
            System.err.print("DefaultRequestHandler.exceptionCaught() threw an exception.");
            t.printStackTrace();
        }
        finally {
            ctx.channel().close();
        }
    }

    private MessageContext createInitialContext(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        Request request = this.createRequest(httpRequest, ctx);
        Response response = this.createResponse();
        MessageContext context = new MessageContext(request, response);
        ctx.attr(CONTEXT_KEY).set(context);
        return context;
    }

    private void resolveRoute(MessageContext context) {
        Action action = this.routeResolver.resolve(context.getRequest());
        context.setAction(action);
    }

    private void notifyReceived(MessageContext context) {
        for (MessageObserver observer : this.messageObservers) {
            observer.onReceived(context.getRequest(), context.getResponse());
        }
    }

    private void notifyComplete(MessageContext context) {
        for (MessageObserver observer : this.messageObservers) {
            observer.onComplete(context.getRequest(), context.getResponse());
        }
    }

    private void notifyException(MessageContext context) {
        Throwable exception = context.getException();
        for (MessageObserver observer : this.messageObservers) {
            observer.onException(exception, context.getRequest(), context.getResponse());
        }
    }

    private void notifySuccess(MessageContext context) {
        for (MessageObserver observer : this.messageObservers) {
            observer.onSuccess(context.getRequest(), context.getResponse());
        }
    }

    public void addPreprocessor(Preprocessor handler) {
        if (!this.preprocessors.contains(handler)) {
            this.preprocessors.add(handler);
        }
    }

    public void addPostprocessor(Postprocessor handler) {
        if (!this.postprocessors.contains(handler)) {
            this.postprocessors.add(handler);
        }
    }

    public void addFinallyProcessor(Postprocessor handler) {
        if (!this.finallyProcessors.contains(handler)) {
            this.finallyProcessors.add(handler);
        }
    }

    private void invokePreprocessors(List<Preprocessor> processors, Request request) {
        for (Preprocessor handler : processors) {
            handler.process(request);
        }
        request.getBody().resetReaderIndex();
    }

    private void invokePostprocessors(List<Postprocessor> processors, Request request, Response response) {
        for (Postprocessor handler : processors) {
            handler.process(request, response);
        }
    }

    private void invokeFinallyProcessors(List<Postprocessor> processors, Request request, Response response) {
        for (Postprocessor handler : processors) {
            try {
                handler.process(request, response);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    private Throwable mapServiceException(Throwable cause) {
        if (ServiceException.isAssignableFrom(cause)) {
            return cause;
        }
        return this.exceptionMap.getExceptionFor(cause);
    }

    private Request createRequest(FullHttpRequest request, ChannelHandlerContext context) {
        try {
            return new Request((InetSocketAddress)context.channel().remoteAddress(), request, this.routeResolver, this.serializationProvider);
        }
        catch (Throwable t) {
            return new Request(request, this.routeResolver, this.serializationProvider);
        }
    }

    private Response createResponse() {
        return new Response();
    }

    private void writeResponse(ChannelHandlerContext ctx, MessageContext context) {
        this.getResponseWriter().write(ctx, context.getRequest(), context.getResponse());
    }

    private void serializeResponse(MessageContext context, boolean force) {
        Response response = context.getResponse();
        if (HttpSpecification.isContentTypeAllowed(response)) {
            ByteBuffer serialized;
            SerializationSettings settings = null;
            if (response.hasSerializationSettings()) {
                settings = response.getSerializationSettings();
            } else if (force) {
                settings = this.serializationProvider.resolveResponse(context.getRequest(), response, force);
            }
            if (settings != null && response.isSerialized() && (serialized = settings.serialize(response)) != null) {
                response.setBody(Unpooled.wrappedBuffer(serialized));
                if (!response.hasHeader("Content-Type")) {
                    response.setContentType(settings.getMediaType());
                }
            }
            if (!response.hasHeader("Content-Type")) {
                response.setContentType("text/plain; charset=UTF-8");
            }
        }
    }
}

