/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.pipeline;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.route.Action;
import org.restexpress.serialization.SerializationSettings;

public class MessageContext {
    private Request request;
    private Response response;
    private Action action = null;

    public MessageContext(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean hasAction() {
        return this.getAction() != null;
    }

    public void setAction(Action action) {
        this.action = action;
        this.addUrlParametersAsHeaders(this.getRequest(), action.getParameters());
        this.getRequest().setResolvedRoute(action.getRoute());
        this.getResponse().setIsSerialized(action.shouldSerializeResponse());
    }

    public Throwable getException() {
        return this.getResponse().getException();
    }

    public void setException(Throwable throwable) {
        this.getResponse().setException(throwable);
    }

    public void setHttpStatus(HttpResponseStatus httpStatus) {
        this.getResponse().setResponseStatus(httpStatus);
    }

    public String getRequestedFormat() {
        String format = null;
        if (this.hasAction()) {
            format = this.getAction().getParameter("format");
        }
        if (format == null || format.trim().isEmpty()) {
            format = this.getRequest().getHeader("format");
        }
        return format;
    }

    public boolean supportsRequestedFormat() {
        if (!this.hasAction()) {
            return false;
        }
        return this.getAction().getRoute().supportsFormat(this.getRequest().getFormat());
    }

    public Collection<String> getSupportedRouteFormats() {
        if (!this.hasAction()) {
            return Collections.emptyList();
        }
        return this.getAction().getRoute().getSupportedFormats();
    }

    private void addUrlParametersAsHeaders(Request request, Collection<Map.Entry<String, String>> parameters) {
        for (Map.Entry<String, String> entry : parameters) {
            try {
                request.addHeader(entry.getKey(), URLDecoder.decode(entry.getValue(), "UTF-8"));
            }
            catch (Exception e) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setSerializationSettings(SerializationSettings settings) {
        this.response.setSerializationSettings(settings);
    }
}

