/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.route.parameterized;

import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restexpress.route.Route;
import org.restexpress.url.UrlMatch;
import org.restexpress.url.UrlPattern;

public class ParameterizedRoute
extends Route {
    private UrlPattern[] aliases;

    public ParameterizedRoute(UrlPattern urlMatcher, Object controller, Method action, HttpMethod method, boolean shouldSerializeResponse, String name, List<String> supportedFormats, String defaultFormat, Set<String> flags, Map<String, Object> parameters, String baseUrl) {
        super(urlMatcher, controller, action, method, shouldSerializeResponse, name, supportedFormats, defaultFormat, flags, parameters, baseUrl);
    }

    public ParameterizedRoute(String urlPattern, Object controller, Method action, HttpMethod method, boolean shouldSerializeResponse, String name, List<String> supportedFormats, String defaultFormat, Set<String> flags, Map<String, Object> parameters, String baseUrl) {
        this(new UrlPattern(urlPattern), controller, action, method, shouldSerializeResponse, name, supportedFormats, defaultFormat, flags, parameters, baseUrl);
    }

    public void addAliases(List<String> uris) {
        if (uris == null) {
            return;
        }
        this.aliases = new UrlPattern[uris.size()];
        int i = 0;
        for (String uri : uris) {
            this.aliases[i++] = new UrlPattern(uri);
        }
    }

    @Override
    public UrlMatch match(String url) {
        UrlMatch match = super.match(url);
        if (match == null && this.aliases != null) {
            UrlPattern alias;
            UrlPattern[] urlPatternArray = this.aliases;
            int n = urlPatternArray.length;
            for (int i = 0; i < n && (match = (alias = urlPatternArray[i]).match(url)) == null; ++i) {
            }
        }
        return match;
    }
}

