/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.url;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restexpress.url.UrlMatch;
import org.restexpress.url.UrlMatcher;

public class UrlPattern
implements UrlMatcher {
    private static final String URL_PARAM_REGEX = "\\{(\\w*?)\\}";
    private static final String URL_PARAM_MATCH_REGEX = "\\([%\\\\w-.\\\\~!\\$&'\\\\(\\\\)\\\\*\\\\+,;=:\\\\[\\\\]@]+?\\)";
    private static final Pattern URL_PARAM_PATTERN = Pattern.compile("\\{(\\w*?)\\}");
    private static final String URL_FORMAT_REGEX = "(?:\\.\\{format\\})$";
    private static final String URL_FORMAT_MATCH_REGEX = "(?:\\\\.\\([\\\\w%]+?\\))?";
    private static final String URL_QUERY_STRING_REGEX = "(?:\\?.*?)?$";
    private String urlPattern;
    private Pattern compiledUrl;
    private List<String> parameterNames = new ArrayList<String>();

    public UrlPattern(String pattern) {
        this.setUrlPattern(pattern);
        this.compile();
    }

    private String getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    public String getPattern() {
        return this.getUrlPattern().replaceFirst(URL_FORMAT_REGEX, "");
    }

    private void setUrlPattern(String pattern) {
        this.urlPattern = pattern;
    }

    @Override
    public List<String> getParameterNames() {
        return Collections.unmodifiableList(this.parameterNames);
    }

    @Override
    public UrlMatch match(String url) {
        Matcher matcher = this.compiledUrl.matcher(url);
        if (matcher.matches()) {
            return new UrlMatch(this.extractParameters(matcher));
        }
        return null;
    }

    @Override
    public boolean matches(String url) {
        return this.match(url) != null;
    }

    public void compile() {
        this.acquireParameterNames();
        String parsedPattern = this.getUrlPattern().replaceFirst(URL_FORMAT_REGEX, URL_FORMAT_MATCH_REGEX);
        parsedPattern = parsedPattern.replaceAll(URL_PARAM_REGEX, URL_PARAM_MATCH_REGEX);
        this.compiledUrl = Pattern.compile(parsedPattern + URL_QUERY_STRING_REGEX);
    }

    private void acquireParameterNames() {
        Matcher m3 = URL_PARAM_PATTERN.matcher(this.getUrlPattern());
        while (m3.find()) {
            this.parameterNames.add(m3.group(1));
        }
    }

    private Map<String, String> extractParameters(Matcher matcher) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < matcher.groupCount(); ++i) {
            String value = matcher.group(i + 1);
            if (value == null) continue;
            values.put(this.parameterNames.get(i), value);
        }
        return values;
    }
}

